/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common;

import io.activej.common.ApplicationSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class Utils {
    public static final int TO_STRING_LIMIT = ApplicationSettings.getInt(Utils.class, "toStringLimit", 10);
    private static final BinaryOperator<?> NO_MERGE_FUNCTION = (v, v2) -> {
        throw new AssertionError();
    };
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    };

    public static <T> T get(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T nonNullElse(@Nullable T value1, T defaultValue) {
        return value1 != null ? value1 : defaultValue;
    }

    public static <T> T nonNullElseGet(@Nullable T value, Supplier<? extends T> defaultValue) {
        return value != null ? value : defaultValue.get();
    }

    public static String nonNullElseEmpty(@Nullable String value) {
        return Utils.nonNullElse(value, "");
    }

    public static <T> Set<T> nonNullElseEmpty(@Nullable Set<T> set) {
        return Utils.nonNullElse(set, Collections.emptySet());
    }

    public static <T> List<T> nonNullElseEmpty(@Nullable List<T> list) {
        return Utils.nonNullElse(list, Collections.emptyList());
    }

    public static <K, V> Map<K, V> nonNullElseEmpty(@Nullable Map<K, V> map) {
        return Utils.nonNullElse(map, Collections.emptyMap());
    }

    @NotNull
    public static <T, E extends Throwable> T nonNullOrException(@Nullable T value, Supplier<@NotNull E> exceptionSupplier) throws E {
        if (value != null) {
            return value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @Contract(value="_, _ -> null")
    @Nullable
    public static <V> V nullify(@Nullable V value, @NotNull Runnable action) {
        if (value != null) {
            action.run();
        }
        return null;
    }

    @Contract(value="_, _ -> null")
    @Nullable
    public static <V> V nullify(@Nullable V value, @NotNull Consumer<? super V> action) {
        if (value != null) {
            action.accept(value);
        }
        return null;
    }

    @Contract(value="_, _, _ -> null")
    @Nullable
    public static <V, A> V nullify(@Nullable V value, @NotNull BiConsumer<? super V, A> action, A actionArg) {
        if (value != null) {
            action.accept(value, actionArg);
        }
        return null;
    }

    public static boolean arraysEquals(byte[] array1, int pos1, int len1, byte[] array2, int pos2, int len2) {
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (array1[pos1 + i] == array2[pos2 + i]) continue;
            return false;
        }
        return true;
    }

    public static <D> List<D> concat(List<? extends D> list1, List<? extends D> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        Object[] objects = new Object[list1.size() + list2.size()];
        System.arraycopy(list1.toArray(), 0, objects, 0, list1.size());
        System.arraycopy(list2.toArray(), 0, objects, list1.size(), list2.size());
        return Arrays.asList(objects);
    }

    public static <T> Set<T> setOf(T item) {
        return Collections.singleton(item);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        return new LinkedHashSet<T>(Arrays.asList(items));
    }

    public static <T> Set<T> difference(Set<? extends T> a, Set<? extends T> b) {
        if (b.isEmpty()) {
            return a;
        }
        return a.stream().filter(t -> !b.contains(t)).collect(Collectors.toSet());
    }

    public static <T> Set<T> intersection(Set<? extends T> a, Set<? extends T> b) {
        return a.size() < b.size() ? a.stream().filter(b::contains).collect(Collectors.toSet()) : b.stream().filter(a::contains).collect(Collectors.toSet());
    }

    public static <T> boolean hasIntersection(Set<? extends T> a, Set<? extends T> b) {
        return a.size() < b.size() ? a.stream().anyMatch(b::contains) : b.stream().anyMatch(a::contains);
    }

    public static <T> Set<T> union(Set<? extends T> a, Set<? extends T> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        return Stream.concat(a.stream(), b.stream()).collect(Collectors.toCollection(() -> new HashSet(Math.max(a.size(), b.size()))));
    }

    public static <T> T first(List<? extends T> list) {
        return list.get(0);
    }

    public static <T> T first(Iterable<? extends T> iterable) {
        return iterable.iterator().next();
    }

    public static <T> T last(List<? extends T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T last(Iterable<? extends T> iterable) {
        T value;
        Iterator<T> iterator = iterable.iterator();
        do {
            value = iterator.next();
        } while (iterator.hasNext());
        return value;
    }

    public static <T> List<T> listOf() {
        return Collections.emptyList();
    }

    public static <T> List<T> listOf(T value) {
        return Collections.singletonList(value);
    }

    public static <T> List<T> listOf(T ... items) {
        return Arrays.asList(items);
    }

    public static <T> Iterator<T> iteratorOf() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> iteratorOf(final T item) {
        return new Iterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return item;
            }
        };
    }

    public static <T> Iterator<T> iteratorOf(final T item1, final T item2) {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 2;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.i++ == 0 ? item1 : item2;
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> iteratorOf(final T ... items) {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < items.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return items[this.i++];
            }
        };
    }

    public static <T, R> Iterator<R> transformIterator(final Iterator<? extends T> iterator, final Function<? super T, ? extends R> fn) {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public R next() {
                return fn.apply(iterator.next());
            }
        };
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2) {
        return Utils.concatImpl(Utils.iteratorOf(iterator1, iterator2));
    }

    public static <T> Iterator<T> append(Iterator<? extends T> iterator, T value) {
        return Utils.concatImpl(Utils.iteratorOf(iterator, Utils.iteratorOf(value)));
    }

    public static <T> Iterator<T> prepend(T value, Iterator<? extends T> iterator) {
        return Utils.concatImpl(Utils.iteratorOf(Utils.iteratorOf(value), iterator));
    }

    private static <T> Iterator<T> concatImpl(final Iterator<? extends Iterator<? extends T>> iterators) {
        return new Iterator<T>(){
            @Nullable
            Iterator<? extends T> it;
            {
                this.it = iterators.hasNext() ? (Iterator)iterators.next() : null;
            }

            @Override
            public boolean hasNext() {
                return this.it != null;
            }

            @Override
            public T next() {
                if (this.it == null) {
                    throw new NoSuchElementException();
                }
                Object next = this.it.next();
                if (!this.it.hasNext()) {
                    this.it = iterators.hasNext() ? (Iterator)iterators.next() : null;
                }
                return next;
            }
        };
    }

    public static <K, V> Map<K, V> mapOf() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        return map;
    }

    public static boolean isBijection(Map<?, ?> map) {
        return new HashSet(map.values()).size() == map.size();
    }

    public static <T> Stream<T> iterate(@NotNull Supplier<? extends T> supplier, @NotNull Predicate<? super T> hasNext) {
        return Utils.iterate(supplier.get(), hasNext, $ -> supplier.get());
    }

    public static <T> Stream<T> iterate(final T seed, final @NotNull Predicate<? super T> hasNext, final @NotNull UnaryOperator<T> f) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){
            T item;
            {
                this.item = seed;
            }

            @Override
            public boolean hasNext() {
                return hasNext.test(this.item);
            }

            @Override
            public T next() {
                Object next = this.item;
                this.item = f.apply(this.item);
                return next;
            }
        }, 1040), false);
    }

    public static <T> BinaryOperator<T> noMergeFunction() {
        return NO_MERGE_FUNCTION;
    }

    public static <K, V> Map<K, V> keysToMap(Stream<? extends K> stream, Function<? super K, ? extends V> fn) {
        return stream.collect(Collectors.toMap(Function.identity(), fn, Utils.noMergeFunction(), LinkedHashMap::new));
    }

    public static <K, V> Map<K, V> entriesToMap(Stream<? extends Map.Entry<? extends K, ? extends V>> stream) {
        return Utils.entriesToMap(stream, Function.identity());
    }

    public static <K, V, R> Map<K, R> entriesToMap(Stream<? extends Map.Entry<? extends K, ? extends V>> stream, Function<? super V, ? extends R> fn) {
        return stream.collect(Collectors.toMap(Map.Entry::getKey, entry -> fn.apply((Object)entry.getValue()), Utils.noMergeFunction(), LinkedHashMap::new));
    }

    public static <K, V, R> Map<K, R> transformMap(Map<? extends K, ? extends V> map, Function<? super V, ? extends R> function) {
        return Utils.entriesToMap(map.entrySet().stream(), function);
    }

    public static <T> String toString(Collection<? extends T> collection) {
        return Utils.toString(collection, TO_STRING_LIMIT);
    }

    public static <K, V> String toString(Map<? extends K, ? extends V> map) {
        return Utils.toString(map, TO_STRING_LIMIT);
    }

    public static <T> String toString(Collection<? extends T> collection, int limit) {
        return collection.stream().limit(limit).map(Object::toString).collect(Collectors.joining(",", "[", collection.size() <= limit ? "]" : ", ..and " + (collection.size() - limit) + " more]"));
    }

    public static <K, V> String toString(Map<? extends K, ? extends V> map, int limit) {
        return map.entrySet().stream().limit(limit).map(element -> element.getKey() + "=" + element.getValue()).collect(Collectors.joining(",", "{", map.size() <= limit ? "}" : ", ..and " + (map.size() - limit) + " more}"));
    }
}

