/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.exception;

import io.activej.common.exception.FatalErrorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FatalErrorHandlers {
    private static volatile FatalErrorHandler globalFatalErrorHandler = FatalErrorHandler.rethrow();
    private static final ThreadLocal<FatalErrorHandler> CURRENT_HANDLER = new ThreadLocal();

    public static void setThreadFatalErrorHandler(@Nullable FatalErrorHandler handler) {
        if (handler == null) {
            CURRENT_HANDLER.remove();
        } else {
            CURRENT_HANDLER.set(handler);
        }
    }

    public static void setGlobalFatalErrorHandler(@NotNull FatalErrorHandler handler) {
        globalFatalErrorHandler = handler;
    }

    @NotNull
    public static FatalErrorHandler getFatalErrorHandler() {
        FatalErrorHandler handler = CURRENT_HANDLER.get();
        return handler != null ? handler : globalFatalErrorHandler;
    }

    public static void handleError(@NotNull FatalErrorHandler fatalErrorHandler, @NotNull Throwable e, @Nullable Object context) {
        if (e instanceof RuntimeException || !(e instanceof Exception)) {
            fatalErrorHandler.handle(e, context);
        }
    }

    public static void handleError(@NotNull Throwable e, @Nullable Object context) {
        if (e instanceof RuntimeException || !(e instanceof Exception)) {
            FatalErrorHandlers.getFatalErrorHandler().handle(e, context);
        }
    }

    public static void handleError(@NotNull Throwable e) {
        FatalErrorHandlers.handleError(e, null);
    }

    @NotNull
    public static Exception getExceptionOrThrowError(@NotNull Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new Error(t);
    }
}

