/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.exception.UncheckedException;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface BiPredicateEx<T, U> {
    public boolean test(T var1, U var2) throws Exception;

    public static <T, U> BiPredicateEx<T, U> of(BiPredicate<T, U> uncheckedFn) {
        return (t, u) -> {
            try {
                return uncheckedFn.test(t, u);
            }
            catch (UncheckedException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T, U> BiPredicate<T, U> uncheckedOf(BiPredicateEx<T, U> checkedFn) {
        return (t, u) -> {
            try {
                return checkedFn.test(t, u);
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError(ex, checkedFn);
                throw UncheckedException.of(ex);
            }
        };
    }
}

