/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.exception.UncheckedException;
import java.util.function.Consumer;

@FunctionalInterface
public interface ConsumerEx<T> {
    public void accept(T var1) throws Exception;

    public static <T> ConsumerEx<T> of(Consumer<T> uncheckedFn) {
        return t -> {
            try {
                uncheckedFn.accept(t);
            }
            catch (UncheckedException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T> Consumer<T> uncheckedOf(ConsumerEx<T> checkedFn) {
        return t -> {
            try {
                checkedFn.accept(t);
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError(ex, checkedFn);
                throw UncheckedException.of(ex);
            }
        };
    }
}

