/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.recycle;

import io.activej.common.Utils;
import io.activej.common.recycle.Recyclable;
import io.activej.common.recycle.Recycler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Recyclers {
    private static final Recycler<?> NO_RECYCLER = item -> {};
    private static final Map<Class<?>, Recycler<?>> REGISTRY = new HashMap();
    private static final ConcurrentHashMap<Class<?>, Recycler<?>> CACHED_RECYCLERS = new ConcurrentHashMap();

    public static synchronized <T> void register(Class<T> type, Recycler<T> item) {
        REGISTRY.put(type, item);
        for (Map.Entry<Class<?>, Recycler<?>> entry : CACHED_RECYCLERS.entrySet()) {
            Recycler<?> cachedRecyclerNew;
            Class<?> cachedType = entry.getKey();
            Recycler<?> cachedRecyclerOld = entry.getValue();
            if (cachedRecyclerOld.equals(cachedRecyclerNew = Recyclers.lookup(cachedType))) continue;
            throw new IllegalStateException("Changed recycler for " + type + " in cache entry " + cachedType);
        }
    }

    public static void recycle(Object object) {
        if (object == null) {
            return;
        }
        Recycler<?> recycler = Recyclers.ensureRecycler(object.getClass());
        if (recycler != NO_RECYCLER) {
            recycler.recycle(object);
        }
    }

    @NotNull
    public static Recycler<?> ensureRecycler(@NotNull Class<?> type) {
        Recycler<?> recycler = CACHED_RECYCLERS.get(type);
        if (recycler != null) {
            return recycler;
        }
        return Recyclers.doCache(type);
    }

    @NotNull
    private static synchronized Recycler<?> doCache(@NotNull Class<?> type) {
        Recycler<?> recycler = Recyclers.lookup(type);
        CACHED_RECYCLERS.put(type, recycler);
        return recycler;
    }

    private static Recycler<?> lookup(@NotNull Class<?> type) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
            }
            if (componentType.isPrimitive()) {
                return NO_RECYCLER;
            }
            return Recyclers::recycleArray;
        }
        Map<Class<?>, Recycler<?>> recyclers = Recyclers.doLookup(type);
        if (recyclers.isEmpty()) {
            return NO_RECYCLER;
        }
        if (recyclers.size() == 1) {
            return Utils.first(recyclers.values());
        }
        throw new IllegalArgumentException("Conflicting recyclers for " + type + " : " + recyclers.keySet());
    }

    @NotNull
    private static Map<Class<?>, Recycler<?>> doLookup(@NotNull Class<?> type) {
        @Nullable Recycler<?> recycler = REGISTRY.get(type);
        if (recycler != null) {
            return Collections.singletonMap(type, recycler);
        }
        HashMap map = new HashMap();
        @Nullable Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            map.putAll(Recyclers.doLookup(superclass));
        }
        for (Class<?> anInterface : type.getInterfaces()) {
            map.putAll(Recyclers.doLookup(anInterface));
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            boolean isAssignable = false;
            Class key1 = (Class)entry.getKey();
            for (Class key2 : map.keySet()) {
                if (key1 == key2 || !key1.isAssignableFrom(key2)) continue;
                isAssignable = true;
                break;
            }
            if (isAssignable) continue;
            result.put(key1, (Recycler)entry.getValue());
        }
        return result;
    }

    private static void recycleCloseable(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void recycleList(List<?> list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Recyclers.recycle(list.get(i));
        }
    }

    private static void recycleArray(Object[] array) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            Recyclers.recycle(array[i]);
        }
    }

    private static void recycleMap(Map<?, ?> map) {
        for (Object item : map.values()) {
            Recyclers.recycle(item);
        }
    }

    static {
        Recyclers.register(Recyclable.class, Recyclable::recycle);
        Recyclers.register(AutoCloseable.class, Recyclers::recycleCloseable);
        Recyclers.register(List.class, Recyclers::recycleList);
        Recyclers.register(Map.class, Recyclers::recycleMap);
        Recyclers.register(Optional.class, optional -> optional.ifPresent(Recyclers::recycle));
        Recyclers.register(CompletionStage.class, future -> future.thenAccept(Recyclers::recycle));
    }
}

