/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.reflection;

import io.activej.common.Checks;
import io.activej.common.exception.UncheckedException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    public static boolean isPrimitiveType(Class<?> cls) {
        return cls == Boolean.TYPE || cls == Byte.TYPE || cls == Character.TYPE || cls == Short.TYPE || cls == Integer.TYPE || cls == Long.TYPE || cls == Float.TYPE || cls == Double.TYPE;
    }

    public static boolean isBoxedPrimitiveType(Class<?> cls) {
        return cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class;
    }

    public static boolean isPrimitiveTypeOrBox(Class<?> cls) {
        return ReflectionUtils.isPrimitiveType(cls) || ReflectionUtils.isBoxedPrimitiveType(cls);
    }

    public static boolean isSimpleType(Class<?> cls) {
        return ReflectionUtils.isPrimitiveTypeOrBox(cls) || cls == String.class;
    }

    public static boolean isThrowable(Class<?> cls) {
        return Throwable.class.isAssignableFrom(cls);
    }

    public static boolean isPublic(Class<?> cls) {
        return Modifier.isPublic(cls.getModifiers());
    }

    public static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isGetter(Method method) {
        return method.getName().length() > 2 && method.getParameterCount() == 0 && (method.getName().startsWith("get") && method.getReturnType() != Void.TYPE || method.getName().startsWith("is") && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class));
    }

    public static boolean isSetter(Method method) {
        return method.getName().length() > 3 && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && method.getParameterCount() == 1;
    }

    public static String extractFieldNameFromGetter(Method getter) {
        return ReflectionUtils.extractFieldNameFromGetterName(getter.getName());
    }

    public static String extractFieldNameFromGetterName(String getterName) {
        if (getterName.startsWith("get")) {
            if (getterName.length() == 3) {
                return "";
            }
            String firstLetter = getterName.substring(3, 4);
            String restOfName = getterName.substring(4);
            return firstLetter.toLowerCase() + restOfName;
        }
        if (getterName.startsWith("is") && getterName.length() > 2) {
            String firstLetter = getterName.substring(2, 3);
            String restOfName = getterName.substring(3);
            return firstLetter.toLowerCase() + restOfName;
        }
        throw new IllegalArgumentException("Given method is not a getter");
    }

    public static String extractFieldNameFromSetter(Method setter) {
        return ReflectionUtils.extractFieldNameFromSetterName(setter.getName());
    }

    public static String extractFieldNameFromSetterName(String setterName) {
        Checks.checkArgument(setterName.startsWith("set") && setterName.length() > 3, "Given method is not a setter");
        String firstLetter = setterName.substring(3, 4);
        String restOfName = setterName.substring(4);
        return firstLetter.toLowerCase() + restOfName;
    }

    @Nullable
    private static <T> Supplier<T> getConstructorOrFactory(Class<T> cls, String ... factoryMethodNames) {
        for (String methodName : factoryMethodNames) {
            Method method;
            try {
                method = cls.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if ((method.getModifiers() & 9) == 0 || method.getReturnType() != cls) continue;
            return () -> {
                try {
                    return method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw UncheckedException.of(e);
                }
            };
        }
        return Arrays.stream(cls.getConstructors()).filter(c -> c.getParameterTypes().length == 0).findAny().map(c -> () -> {
            try {
                return c.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw UncheckedException.of(e);
            }
        }).orElse(null);
    }

    public static boolean canBeCreated(Class<?> cls, String ... factoryMethodNames) {
        return ReflectionUtils.getConstructorOrFactory(cls, factoryMethodNames) != null;
    }

    @Nullable
    public static <T> T tryToCreateInstanceWithFactoryMethods(Class<T> cls, String ... factoryMethodNames) {
        try {
            Supplier<T> supplier = ReflectionUtils.getConstructorOrFactory(cls, factoryMethodNames);
            return supplier != null ? (T)supplier.get() : null;
        }
        catch (UncheckedException u) {
            return null;
        }
    }

    public static boolean isClassPresent(String fullClassName) {
        return ReflectionUtils.isClassPresent(fullClassName, ReflectionUtils.class.getClassLoader());
    }

    public static boolean isClassPresent(String fullClassName, ClassLoader classLoader) {
        try {
            Class.forName(fullClassName, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<Method> getAllMethods(Class<?> cls) {
        LinkedHashSet methodSignatures = new LinkedHashSet();
        ReflectionUtils.walkClassHierarchy(cls, aClass -> {
            Arrays.stream(aClass.getDeclaredMethods()).filter(method -> !method.isBridge() && !method.isSynthetic()).map(MethodSignature::new).forEach(methodSignatures::add);
            return Optional.empty();
        });
        return methodSignatures.stream().map(MethodSignature::getMethod).collect(Collectors.toList());
    }

    public static <A extends Annotation> Optional<A> deepFindAnnotation(Class<?> aClass, Class<A> annotation) {
        return ReflectionUtils.walkClassHierarchy(aClass, clazz -> Optional.ofNullable(clazz.getAnnotation(annotation)));
    }

    public static <T> Optional<T> walkClassHierarchy(@NotNull Class<?> aClass, @NotNull Function<Class<?>, Optional<T>> finder) {
        return ReflectionUtils.walkClassHierarchy(aClass, finder, new HashSet());
    }

    private static <T> Optional<T> walkClassHierarchy(@Nullable Class<?> aClass, @NotNull Function<Class<?>, Optional<T>> finder, @NotNull Set<Class<?>> visited) {
        if (aClass == null || !visited.add(aClass)) {
            return Optional.empty();
        }
        Optional<T> maybeResult = finder.apply(aClass);
        if (maybeResult.isPresent()) {
            return maybeResult;
        }
        for (Class<?> iface : aClass.getInterfaces()) {
            maybeResult = ReflectionUtils.walkClassHierarchy(iface, finder, visited);
            if (!maybeResult.isPresent()) continue;
            return maybeResult;
        }
        return ReflectionUtils.walkClassHierarchy(aClass.getSuperclass(), finder, visited);
    }

    public static String getAnnotationString(Annotation annotation) throws ReflectiveOperationException {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        StringBuilder annotationString = new StringBuilder();
        Method[] annotationElements = ReflectionUtils.filterNonEmptyElements(annotation);
        if (annotationElements.length == 0) {
            annotationString.append(annotationType.getSimpleName());
            return annotationString.toString();
        }
        if (annotationElements.length == 1 && annotationElements[0].getName().equals("value")) {
            annotationString.append(annotationType.getSimpleName());
            Object value = ReflectionUtils.fetchAnnotationElementValue(annotation, annotationElements[0]);
            annotationString.append("(" + value + ")");
            return annotationString.toString();
        }
        annotationString.append('(');
        for (Method annotationParameter : annotationElements) {
            Object value = ReflectionUtils.fetchAnnotationElementValue(annotation, annotationParameter);
            String nameKey = annotationParameter.getName();
            String nameValue = value.toString();
            annotationString.append(nameKey + "=" + nameValue + ",");
        }
        assert (annotationString.substring(annotationString.length() - 1).equals(","));
        annotationString = new StringBuilder(annotationString.substring(0, annotationString.length() - 1));
        annotationString.append(')');
        return annotationString.toString();
    }

    private static Method[] filterNonEmptyElements(Annotation annotation) throws ReflectiveOperationException {
        ArrayList<Method> filtered = new ArrayList<Method>();
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            String stringValue;
            Object elementValue = ReflectionUtils.fetchAnnotationElementValue(annotation, method);
            if (elementValue instanceof String && (stringValue = (String)elementValue).length() == 0) continue;
            filtered.add(method);
        }
        return filtered.toArray(new Method[0]);
    }

    public static Object fetchAnnotationElementValue(Annotation annotation, Method element) throws ReflectiveOperationException {
        Object value = element.invoke((Object)annotation, new Object[0]);
        if (value == null) {
            String errorMsg = "@" + annotation.annotationType().getName() + "." + element.getName() + "() returned null";
            throw new NullPointerException(errorMsg);
        }
        return value;
    }

    private static final class MethodSignature {
        final Method method;

        MethodSignature(Method method) {
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object obj) {
            Method otherMethod = ((MethodSignature)obj).method;
            return this.method.getName().equals(otherMethod.getName()) && Arrays.equals(this.method.getParameterTypes(), otherMethod.getParameterTypes());
        }

        public int hashCode() {
            return this.method.getName().hashCode() ^ Arrays.hashCode(this.method.getParameterTypes());
        }
    }
}

