/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.tuple;

import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.Contract;

public final class Tuple2<T1, T2> {
    private final T1 value1;
    private final T2 value2;

    public Tuple2(T1 value1, T2 value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    @Contract(pure=true)
    public T1 getValue1() {
        return this.value1;
    }

    @Contract(pure=true)
    public T2 getValue2() {
        return this.value2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple2 that = (Tuple2)o;
        return Objects.equals(this.value1, that.value1) && Objects.equals(this.value2, that.value2);
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2);
    }

    public String toString() {
        return new StringJoiner(", ", "{", "}").add("" + this.value1).add("" + this.value2).toString();
    }
}

