/*
 * Copyright (C) 2020 ActiveJ LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.activej.common.exception;

/**
 * An exception that represents an unknown data format
 */
public class UnknownFormatException extends MalformedDataException {
	public UnknownFormatException() {
		super("Unknown format");
	}

	public UnknownFormatException(String message) {
		super(message);
	}

	public UnknownFormatException(String message, Throwable cause) {
		super(message, cause);
	}
}
