/*
 * Copyright (C) 2020 ActiveJ LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.activej.common.ref;

public final class Ref<T> {
	public T value;

	public Ref(T value) {
		this.value = value;
	}

	public Ref() {
		this(null);
	}

	public T get() {
		return value;
	}

	public void set(T peer) {
		this.value = peer;
	}

	public void unset() {
		this.value = null;
	}

	@Override
	public String toString() {
		return "→" + value;
	}
}
