/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common;

import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.StringFormatUtils;
import io.activej.common.exception.MalformedDataException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class ApplicationSettings {
    private static final Map<Class<?>, Map<String, Object>> customSettings = new HashMap();
    private static Properties properties = System.getProperties();
    private static volatile boolean firstLookupDone = false;

    public static void useProperties(Properties properties) {
        ApplicationSettings.ensureNotLookedUp();
        ApplicationSettings.properties = properties;
    }

    public static void set(Class<?> type, String name, Object value) {
        ApplicationSettings.ensureNotLookedUp();
        customSettings.computeIfAbsent(type, $ -> new HashMap()).put(name, value);
    }

    public static <T> T get(Function<String, T> parser, Class<?> type, String name, T defValue) {
        Checks.checkState(!type.isAnonymousClass(), "Anonymous classes cannot be used for application settings");
        firstLookupDone = true;
        Object customSetting = customSettings.getOrDefault(type, Collections.emptyMap()).get(name);
        if (customSetting != null) {
            return (T)customSetting;
        }
        String property = ApplicationSettings.getProperty(type, name);
        if (property != null) {
            return parser.apply(property);
        }
        return defValue;
    }

    public static String getString(Class<?> type, String name, String defValue) {
        return ApplicationSettings.get(Function.identity(), type, name, defValue);
    }

    public static int getInt(Class<?> type, String name, int defValue) {
        return ApplicationSettings.get(Integer::parseInt, type, name, defValue);
    }

    public static long getLong(Class<?> type, String name, long defValue) {
        return ApplicationSettings.get(Long::parseLong, type, name, defValue);
    }

    public static boolean getBoolean(Class<?> type, String name, boolean defValue) {
        return ApplicationSettings.get(s -> s.trim().isEmpty() || Boolean.parseBoolean(s), type, name, defValue);
    }

    public static double getDouble(Class<?> type, String name, double defValue) {
        return ApplicationSettings.get(Double::parseDouble, type, name, defValue);
    }

    public static Duration getDuration(Class<?> type, String name, Duration defValue) {
        return ApplicationSettings.get(StringFormatUtils::parseDuration, type, name, defValue);
    }

    public static MemSize getMemSize(Class<?> type, String name, MemSize defValue) {
        return ApplicationSettings.get(MemSize::valueOf, type, name, defValue);
    }

    public static InetSocketAddress getInetSocketAddress(Class<?> type, String name, InetSocketAddress defValue) {
        return ApplicationSettings.get(address -> {
            try {
                return StringFormatUtils.parseInetSocketAddressResolving(address);
            }
            catch (MalformedDataException e) {
                throw new RuntimeException("Malformed inet socket address: " + address, e);
            }
        }, type, name, defValue);
    }

    public static Charset getCharset(Class<?> type, String name, Charset defValue) {
        return ApplicationSettings.get(charset -> {
            try {
                return Charset.forName(charset);
            }
            catch (UnsupportedCharsetException e) {
                throw new RuntimeException("Unsupported charset: " + charset, e);
            }
        }, type, name, defValue);
    }

    public static Locale getLocale(Class<?> type, String name, Locale defValue) {
        return ApplicationSettings.get(Locale::forLanguageTag, type, name, defValue);
    }

    public static <E extends Enum<E>> E getEnum(Class<?> type, String name, Class<E> enumClass, E defValue) {
        return (E)ApplicationSettings.get(val -> Enum.valueOf(enumClass, val), type, name, defValue);
    }

    @Nullable
    private static String getProperty(Class<?> type, String name) {
        String property = properties.getProperty(type.getName() + "." + name);
        if (property != null) {
            return property;
        }
        property = properties.getProperty(type.getSimpleName() + "." + name);
        return property;
    }

    private static void ensureNotLookedUp() {
        if (firstLookupDone) {
            throw new IllegalStateException("Attempting to update application settings after some of them have been retrieved\nAll updates should happen prior to any constant initialization via ApplicationSettings, preferably in static initialization block of 'main' class");
        }
    }
}

