/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Checks {
    private static final boolean ENABLED_BY_DEFAULT;
    private static final String ENV_PREFIX = "chk:";

    public static boolean isEnabled(Class<?> cls) {
        Checks.checkState(!cls.isAnonymousClass(), "Anonymous classes cannot be used for checks");
        String path = cls.getName();
        String property = System.getProperty(ENV_PREFIX + path);
        if (property == null) {
            int idx;
            property = System.getProperty(ENV_PREFIX + cls.getSimpleName());
            while (property == null && (idx = path.lastIndexOf(46)) != -1) {
                path = path.substring(0, idx);
                property = System.getProperty(ENV_PREFIX + path);
            }
        }
        boolean enabled = ENABLED_BY_DEFAULT;
        if (property != null) {
            if (property.equals("on")) {
                enabled = true;
            } else if (property.equals("off")) {
                enabled = false;
            } else {
                throw new RuntimeException(Checks.getErrorMessage(property));
            }
        }
        return enabled;
    }

    public static boolean isEnabledByDefault() {
        return ENABLED_BY_DEFAULT;
    }

    @NotNull
    public static <T> T checkNotNull(@Nullable T reference) {
        if (reference != null) {
            return reference;
        }
        throw new NullPointerException();
    }

    @NotNull
    public static <T> T checkNotNull(@Nullable T reference, Object message) {
        if (reference != null) {
            return reference;
        }
        throw new NullPointerException(String.valueOf(message));
    }

    @NotNull
    public static <T> T checkNotNull(@Nullable T reference, Supplier<String> message) {
        if (reference != null) {
            return reference;
        }
        throw new NullPointerException(message.get());
    }

    @NotNull
    public static <T> T checkNotNull(@Nullable T reference, String template, Object ... args) {
        if (reference != null) {
            return reference;
        }
        throw new NullPointerException(String.format(template, args));
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object message) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(message));
        }
    }

    public static void checkState(boolean expression, Supplier<String> message) {
        if (!expression) {
            throw new IllegalStateException(message.get());
        }
    }

    public static void checkState(boolean expression, String template, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(template, args));
        }
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object message) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(message));
        }
    }

    public static void checkArgument(boolean expression, Supplier<String> message) {
        if (!expression) {
            throw new IllegalArgumentException(message.get());
        }
    }

    public static void checkArgument(boolean expression, String template, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(template, args));
        }
    }

    public static <T> T checkArgument(T argument, Predicate<T> predicate) {
        if (predicate.test(argument)) {
            return argument;
        }
        throw new IllegalArgumentException();
    }

    public static <T> T checkArgument(T argument, Predicate<T> predicate, Object message) {
        if (predicate.test(argument)) {
            return argument;
        }
        throw new IllegalArgumentException(String.valueOf(message));
    }

    public static <T> T checkArgument(T argument, Predicate<T> predicate, Supplier<String> message) {
        if (predicate.test(argument)) {
            return argument;
        }
        throw new IllegalArgumentException(message.get());
    }

    public static <T> T checkArgument(T argument, Predicate<T> predicate, Function<T, String> message) {
        if (predicate.test(argument)) {
            return argument;
        }
        throw new IllegalArgumentException(message.apply(argument));
    }

    public static <T> T checkArgument(T argument, Predicate<T> predicate, String template, Object ... args) {
        if (predicate.test(argument)) {
            return argument;
        }
        throw new IllegalArgumentException(String.format(template, args));
    }

    private static String getErrorMessage(String value) {
        return "Only 'on' and 'off' values are allowed for 'chk' system properties, was '" + value + '\'';
    }

    static {
        String enabled = System.getProperty("chk");
        if (enabled == null) {
            boolean asserts = false;
            if (!$assertionsDisabled) {
                asserts = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            ENABLED_BY_DEFAULT = asserts;
        } else if (enabled.equals("off")) {
            ENABLED_BY_DEFAULT = false;
        } else if (enabled.equals("on")) {
            ENABLED_BY_DEFAULT = true;
        } else {
            throw new RuntimeException(Checks.getErrorMessage(enabled));
        }
    }
}

