/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common;

import io.activej.common.Checks;
import io.activej.common.StringFormatUtils;
import java.util.function.LongUnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class MemSize
implements Comparable<MemSize> {
    public static final MemSize ZERO = new MemSize(0L);
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    private final long bytes;

    private MemSize(long bytes) {
        this.bytes = bytes;
    }

    @NotNull
    public static MemSize of(long bytes) {
        Checks.checkArgument(bytes >= 0L, "Cannot create MemSize of negative value");
        return new MemSize(bytes);
    }

    @NotNull
    public static MemSize bytes(long bytes) {
        return MemSize.of(bytes);
    }

    @NotNull
    public static MemSize kilobytes(long kilobytes) {
        Checks.checkArgument(kilobytes <= 0x1FFFFFFFFFFFFFL, "Resulting number of bytes exceeds Long.MAX_VALUE");
        return MemSize.of(kilobytes * 1024L);
    }

    @NotNull
    public static MemSize megabytes(long megabytes) {
        Checks.checkArgument(megabytes <= 0x7FFFFFFFFFFL, "Resulting number of bytes exceeds Long.MAX_VALUE");
        return MemSize.of(megabytes * 0x100000L);
    }

    @NotNull
    public static MemSize gigabytes(long gigabytes) {
        Checks.checkArgument(gigabytes <= 0x1FFFFFFFFL, "Resulting number of bytes exceeds Long.MAX_VALUE");
        return MemSize.of(gigabytes * 0x40000000L);
    }

    @NotNull
    public static MemSize terabytes(long terabytes) {
        Checks.checkArgument(terabytes <= 0x7FFFFFL, "Resulting number of bytes exceeds Long.MAX_VALUE");
        return MemSize.of(terabytes * 0x10000000000L);
    }

    public long toLong() {
        return this.bytes;
    }

    public int toInt() {
        if (this.bytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("MemSize exceeds Integer.MAX_VALUE: " + this.bytes);
        }
        return (int)this.bytes;
    }

    @NotNull
    public MemSize map(@NotNull LongUnaryOperator fn) {
        return MemSize.of(fn.applyAsLong(this.bytes));
    }

    @NotNull
    public static MemSize valueOf(@NotNull String string) {
        return StringFormatUtils.parseMemSize(string);
    }

    @NotNull
    public String format() {
        return StringFormatUtils.formatMemSize(this);
    }

    @Override
    public int compareTo(@NotNull MemSize o) {
        return Long.compare(this.bytes, o.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemSize memSize = (MemSize)o;
        return this.bytes == memSize.bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }

    @NotNull
    public String toString() {
        return "" + this.toLong();
    }
}

