/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.collection;

import io.activej.common.recycle.Recyclers;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Either<L, R> {
    @Nullable
    private final L left;
    @Nullable
    private final R right;
    private final boolean isRight;

    private Either(@Nullable L left, @Nullable R right, boolean isRight) {
        this.left = left;
        this.right = right;
        this.isRight = isRight;
    }

    public static <L, R> Either<L, R> left(@Nullable L left) {
        return new Either<L, Object>(left, null, false);
    }

    public static <L, R> Either<L, R> right(@Nullable R right) {
        return new Either<Object, R>(null, right, true);
    }

    @Contract(pure=true)
    public boolean isLeft() {
        return !this.isRight;
    }

    @Contract(pure=true)
    public boolean isRight() {
        return this.isRight;
    }

    @Contract(pure=true)
    @Nullable
    public L getLeft() {
        return this.left;
    }

    @Contract(pure=true)
    @Nullable
    public R getRight() {
        return this.right;
    }

    @Contract(pure=true)
    public L getLeftElse(@Nullable L defaultValue) {
        return this.isLeft() ? this.left : defaultValue;
    }

    @Contract(pure=true)
    public R getRightElse(@Nullable R defaultValue) {
        return this.isRight() ? this.right : defaultValue;
    }

    @Contract(pure=true)
    public L getLeftElseGet(@NotNull Supplier<? extends L> defaultValueSupplier) {
        return this.isLeft() ? this.left : defaultValueSupplier.get();
    }

    @Contract(pure=true)
    public R getRightElseGet(@NotNull Supplier<? extends R> defaultValueSupplier) {
        return this.isRight() ? this.right : defaultValueSupplier.get();
    }

    @Contract(pure=true)
    @NotNull
    public Either<L, R> ifLeft(@NotNull Consumer<? super L> leftConsumer) {
        if (this.isLeft()) {
            leftConsumer.accept(this.left);
        }
        return this;
    }

    @Contract(pure=true)
    @NotNull
    public Either<L, R> ifRight(@NotNull Consumer<? super R> rightConsumer) {
        if (this.isRight()) {
            rightConsumer.accept(this.right);
        }
        return this;
    }

    @Contract(pure=true)
    @NotNull
    public Either<L, R> consume(@NotNull BiConsumer<? super L, ? super R> consumer) {
        consumer.accept(this.left, this.right);
        return this;
    }

    @Contract(pure=true)
    @NotNull
    public Either<L, R> consume(@NotNull Consumer<? super L> leftConsumer, @NotNull Consumer<? super R> rightConsumer) {
        if (this.isLeft()) {
            leftConsumer.accept(this.left);
        } else {
            rightConsumer.accept(this.right);
        }
        return this;
    }

    @Contract(pure=true)
    public <U> U reduce(@NotNull Function<? super L, ? extends U> leftFn, @NotNull Function<? super R, ? extends U> rightFn) {
        return this.isLeft() ? leftFn.apply(this.left) : rightFn.apply(this.right);
    }

    @Contract(pure=true)
    public <U> U reduce(@NotNull BiFunction<? super L, ? super R, ? extends U> fn) {
        return fn.apply(this.left, this.right);
    }

    @Contract(pure=true)
    @NotNull
    public Either<R, L> swap() {
        return new Either<R, L>(this.right, this.left, !this.isRight);
    }

    @Contract(pure=true)
    @NotNull
    public <T> Either<T, R> mapLeft(@NotNull Function<? super L, ? extends T> fn) {
        return this.isLeft() ? new Either<T, Object>(fn.apply(this.left), null, false) : this;
    }

    @Contract(pure=true)
    @NotNull
    public <T> Either<L, T> mapRight(@NotNull Function<? super R, ? extends T> fn) {
        return this.isRight() ? new Either<Object, T>(null, fn.apply(this.right), true) : this;
    }

    @Contract(pure=true)
    @NotNull
    public <T> Either<T, R> flatMapLeft(@NotNull Function<? super L, Either<T, R>> fn) {
        return this.isLeft() ? fn.apply(this.left) : this;
    }

    @Contract(pure=true)
    @NotNull
    public <T> Either<L, T> flatMapRight(@NotNull Function<? super R, Either<L, T>> fn) {
        return this.isRight() ? fn.apply(this.right) : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Either either = (Either)o;
        return Objects.equals(this.left, either.left) && Objects.equals(this.right, either.right);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.left != null ? this.left.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{" + (this.isLeft() ? "left=" + this.left : "right=" + this.right) + "}";
    }

    static {
        Recyclers.register(Either.class, either -> {
            Recyclers.recycle(either.left);
            Recyclers.recycle(either.right);
        });
    }
}

