/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.exception.UncheckedException;
import java.util.function.Predicate;

@FunctionalInterface
public interface PredicateEx<T> {
    public boolean test(T var1) throws Exception;

    public static <T> PredicateEx<T> of(Predicate<T> uncheckedFn) {
        return t -> {
            try {
                return uncheckedFn.test(t);
            }
            catch (UncheckedException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T> Predicate<T> uncheckedOf(PredicateEx<T> checkedFn) {
        return t -> {
            try {
                return checkedFn.test(t);
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError(ex, checkedFn);
                throw UncheckedException.of(ex);
            }
        };
    }
}

