/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.exception.UncheckedException;

@FunctionalInterface
public interface RunnableEx {
    public void run() throws Exception;

    public static RunnableEx of(Runnable uncheckedFn) {
        return () -> {
            try {
                uncheckedFn.run();
            }
            catch (UncheckedException ex) {
                throw ex.getCause();
            }
        };
    }

    public static Runnable uncheckedOf(RunnableEx checkedFn) {
        return () -> {
            try {
                checkedFn.run();
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError(ex, checkedFn);
                throw UncheckedException.of(ex);
            }
        };
    }
}

