/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.initializer;

import java.util.Arrays;
import java.util.function.Consumer;

@FunctionalInterface
public interface Initializer<T>
extends Consumer<T> {
    @SafeVarargs
    public static <T> Initializer<T> combine(Initializer<? super T> ... initializers) {
        return Initializer.combine(Arrays.asList(initializers));
    }

    public static <T> Initializer<T> combine(Iterable<? extends Initializer<? super T>> initializers) {
        return target -> initializers.forEach(initializer -> initializer.accept(target));
    }
}

