/*
 * Decompiled with CFR 0.152.
 */
package io.activej.config.converter;

import io.activej.async.service.EventloopTaskScheduler;
import io.activej.common.MemSize;
import io.activej.common.StringFormatUtils;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.exception.MalformedDataException;
import io.activej.config.Config;
import io.activej.config.converter.ComplexConfigConverter;
import io.activej.config.converter.ConfigConverter;
import io.activej.config.converter.SimpleConfigConverter;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.inspector.ThrottlingController;
import io.activej.eventloop.net.DatagramSocketSettings;
import io.activej.eventloop.net.ServerSocketSettings;
import io.activej.eventloop.net.SocketSettings;
import io.activej.promise.RetryPolicy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class ConfigConverters {
    public static final ConfigConverter<List<Class<?>>> OF_CLASSES = ConfigConverters.ofList(ConfigConverters.ofClass());

    public static ConfigConverter<LocalDate> ofLocalDate() {
        return new SimpleConfigConverter<LocalDate>(){

            @Override
            protected LocalDate fromString(String string) {
                return LocalDate.parse(string);
            }

            @Override
            protected String toString(LocalDate value) {
                return value.toString();
            }
        };
    }

    public static ConfigConverter<LocalTime> ofLocalTime() {
        return new SimpleConfigConverter<LocalTime>(){

            @Override
            protected LocalTime fromString(String string) {
                return LocalTime.parse(string);
            }

            @Override
            protected String toString(LocalTime value) {
                return value.toString();
            }
        };
    }

    public static ConfigConverter<LocalDateTime> ofLocalDateTime() {
        return new SimpleConfigConverter<LocalDateTime>(){

            @Override
            protected LocalDateTime fromString(String string) {
                return StringFormatUtils.parseLocalDateTime((String)string);
            }

            @Override
            protected String toString(LocalDateTime value) {
                return StringFormatUtils.formatLocalDateTime((LocalDateTime)value);
            }
        };
    }

    public static ConfigConverter<Period> ofPeriod() {
        return new SimpleConfigConverter<Period>(){

            @Override
            protected Period fromString(String string) {
                return StringFormatUtils.parsePeriod((String)string);
            }

            @Override
            protected String toString(Period value) {
                return StringFormatUtils.formatPeriod((Period)value);
            }
        };
    }

    public static ConfigConverter<Integer> ofPeriodAsDays() {
        return ConfigConverters.ofPeriod().transform(Period::getDays, Period::ofDays);
    }

    public static ConfigConverter<Duration> ofDuration() {
        return new SimpleConfigConverter<Duration>(){

            @Override
            protected Duration fromString(String string) {
                return StringFormatUtils.parseDuration((String)string);
            }

            @Override
            protected String toString(Duration value) {
                return StringFormatUtils.formatDuration((Duration)value);
            }
        };
    }

    public static ConfigConverter<Long> ofDurationAsMillis() {
        return ConfigConverters.ofDuration().transform(Duration::toMillis, Duration::ofMillis);
    }

    public static ConfigConverter<Instant> ofInstant() {
        return new SimpleConfigConverter<Instant>(){

            @Override
            protected Instant fromString(String string) {
                return StringFormatUtils.parseInstant((String)string);
            }

            @Override
            protected String toString(Instant value) {
                return StringFormatUtils.formatInstant((Instant)value);
            }
        };
    }

    public static ConfigConverter<Long> ofInstantAsEpochMillis() {
        return ConfigConverters.ofInstant().transform(Instant::toEpochMilli, Instant::ofEpochMilli);
    }

    public static ConfigConverter<String> ofString() {
        return new ConfigConverter<String>(){

            @Override
            public String get(Config config, String defaultValue) {
                return config.getValue(defaultValue);
            }

            @Override
            @NotNull
            public String get(Config config) {
                return config.getValue();
            }
        };
    }

    public static ConfigConverter<Byte> ofByte() {
        return new SimpleConfigConverter<Byte>(){

            @Override
            protected Byte fromString(String string) {
                return Byte.valueOf(string);
            }

            @Override
            protected String toString(Byte value) {
                return Byte.toString(value);
            }
        };
    }

    public static ConfigConverter<Integer> ofInteger() {
        return new SimpleConfigConverter<Integer>(){

            @Override
            protected Integer fromString(String string) {
                return Integer.valueOf(string);
            }

            @Override
            protected String toString(Integer value) {
                return Integer.toString(value);
            }
        };
    }

    public static ConfigConverter<Long> ofLong() {
        return new SimpleConfigConverter<Long>(){

            @Override
            public Long fromString(String string) {
                return Long.parseLong(string);
            }

            @Override
            public String toString(Long value) {
                return Long.toString(value);
            }
        };
    }

    public static ConfigConverter<Float> ofFloat() {
        return new SimpleConfigConverter<Float>(){

            @Override
            public Float fromString(String string) {
                return Float.valueOf(Float.parseFloat(string));
            }

            @Override
            public String toString(Float value) {
                return Float.toString(value.floatValue());
            }
        };
    }

    public static ConfigConverter<Double> ofDouble() {
        return new SimpleConfigConverter<Double>(){

            @Override
            public Double fromString(String string) {
                return Double.parseDouble(string);
            }

            @Override
            public String toString(Double value) {
                return Double.toString(value);
            }
        };
    }

    public static ConfigConverter<Boolean> ofBoolean() {
        return new SimpleConfigConverter<Boolean>(){

            @Override
            public Boolean fromString(String string) {
                return Boolean.parseBoolean(string);
            }

            @Override
            public String toString(Boolean value) {
                return Boolean.toString(value);
            }
        };
    }

    public static <E extends Enum<E>> SimpleConfigConverter<E> ofEnum(Class<E> enumClass) {
        final Class<E> enumClass1 = enumClass;
        return new SimpleConfigConverter<E>(){
            private final Class<E> enumClass;
            {
                this.enumClass = enumClass1;
            }

            @Override
            public E fromString(String string) {
                return Enum.valueOf(this.enumClass, string);
            }

            @Override
            public String toString(E value) {
                return ((Enum)value).name();
            }
        };
    }

    public static ConfigConverter<Class<?>> ofClass() {
        return new SimpleConfigConverter<Class<?>>(){

            @Override
            public Class<?> fromString(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public String toString(Class<?> value) {
                return value.getName();
            }
        };
    }

    public static ConfigConverter<InetAddress> ofInetAddress() {
        return new SimpleConfigConverter<InetAddress>(){

            @Override
            public InetAddress fromString(String address) {
                try {
                    return InetAddress.getByName(address);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public String toString(InetAddress value) {
                return value.getHostAddress();
            }
        };
    }

    public static ConfigConverter<InetSocketAddress> ofInetSocketAddress() {
        return new SimpleConfigConverter<InetSocketAddress>(){

            @Override
            public InetSocketAddress fromString(String addressPort) {
                try {
                    return StringFormatUtils.parseInetSocketAddress((String)addressPort);
                }
                catch (MalformedDataException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public String toString(InetSocketAddress value) {
                return value.getAddress().getHostAddress() + ":" + value.getPort();
            }
        };
    }

    public static ConfigConverter<Path> ofPath() {
        return new SimpleConfigConverter<Path>(){

            @Override
            protected Path fromString(String string) {
                return Paths.get(string, new String[0]);
            }

            @Override
            protected String toString(Path value) {
                return value.toAbsolutePath().normalize().toString();
            }
        };
    }

    public static ConfigConverter<MemSize> ofMemSize() {
        return new SimpleConfigConverter<MemSize>(){

            @Override
            public MemSize fromString(String string) {
                return MemSize.valueOf((String)string);
            }

            @Override
            public String toString(MemSize value) {
                return value.format();
            }
        };
    }

    public static ConfigConverter<Long> ofMemSizeAsLong() {
        return ConfigConverters.ofMemSize().transform(MemSize::toLong, MemSize::of);
    }

    public static ConfigConverter<Integer> ofMemSizeAsInt() {
        return ConfigConverters.ofMemSize().transform(MemSize::toInt, MemSize::of);
    }

    public static <T> ConfigConverter<List<T>> ofList(final ConfigConverter<T> elementConverter, final CharSequence separators) {
        return new SimpleConfigConverter<List<T>>(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(separators.chars().mapToObj(c -> "\\" + (char)c).collect(Collectors.joining("", "[", "]")));
            }

            @Override
            public List<T> fromString(String string) {
                return this.pattern.splitAsStream(string).map(String::trim).filter(s -> !s.isEmpty()).map(s -> elementConverter.get(Config.ofValue(s))).collect(Collectors.toList());
            }

            @Override
            public String toString(List<T> value) {
                return value.stream().map(v -> {
                    Config config = Config.ofValue(elementConverter, v);
                    if (config.hasChildren()) {
                        throw new AssertionError((Object)("Unexpected child entries: " + config.toMap()));
                    }
                    return config.getValue();
                }).collect(Collectors.joining(String.valueOf(separators.charAt(0))));
            }
        };
    }

    public static <T> ConfigConverter<List<T>> ofList(ConfigConverter<T> elementConverter) {
        return ConfigConverters.ofList(elementConverter, ",;");
    }

    public static ConfigConverter<ServerSocketSettings> ofServerSocketSettings() {
        return new ComplexConfigConverter<ServerSocketSettings>(ServerSocketSettings.create((int)16384)){

            @Override
            protected ServerSocketSettings provide(Config config, ServerSocketSettings defaultValue) {
                return (ServerSocketSettings)Function.identity().andThen(ConfigConverters.apply(ServerSocketSettings::withBacklog, config.get(ConfigConverters.ofInteger(), "backlog", defaultValue.getBacklog()))).andThen(ConfigConverters.applyIfNotNull(ServerSocketSettings::withReceiveBufferSize, config.get(ConfigConverters.ofMemSize(), "receiveBufferSize", defaultValue.hasReceiveBufferSize() ? defaultValue.getReceiveBufferSize() : null))).andThen(ConfigConverters.applyIfNotNull(ServerSocketSettings::withReuseAddress, config.get(ConfigConverters.ofBoolean(), "reuseAddress", defaultValue.hasReuseAddress() ? Boolean.valueOf(defaultValue.getReuseAddress()) : null))).apply(ServerSocketSettings.create((int)16384));
            }
        };
    }

    public static ConfigConverter<SocketSettings> ofSocketSettings() {
        return new ComplexConfigConverter<SocketSettings>(SocketSettings.create()){

            @Override
            protected SocketSettings provide(Config config, SocketSettings defaultValue) {
                return (SocketSettings)Function.identity().andThen(ConfigConverters.applyIfNotNull(SocketSettings::withReceiveBufferSize, config.get(ConfigConverters.ofMemSize(), "receiveBufferSize", defaultValue.hasReceiveBufferSize() ? defaultValue.getReceiveBufferSize() : null))).andThen(ConfigConverters.applyIfNotNull(SocketSettings::withSendBufferSize, config.get(ConfigConverters.ofMemSize(), "sendBufferSize", defaultValue.hasSendBufferSize() ? defaultValue.getSendBufferSize() : null))).andThen(ConfigConverters.applyIfNotNull(SocketSettings::withReuseAddress, config.get(ConfigConverters.ofBoolean(), "reuseAddress", defaultValue.hasReuseAddress() ? Boolean.valueOf(defaultValue.getReuseAddress()) : null))).andThen(ConfigConverters.applyIfNotNull(SocketSettings::withKeepAlive, config.get(ConfigConverters.ofBoolean(), "keepAlive", defaultValue.hasKeepAlive() ? Boolean.valueOf(defaultValue.getKeepAlive()) : null))).andThen(ConfigConverters.applyIfNotNull(SocketSettings::withTcpNoDelay, config.get(ConfigConverters.ofBoolean(), "tcpNoDelay", defaultValue.hasTcpNoDelay() ? Boolean.valueOf(defaultValue.getTcpNoDelay()) : null))).andThen(ConfigConverters.applyIfNotNull(SocketSettings::withLingerTimeout, config.get(ConfigConverters.ofDuration(), "lingerTimeout", defaultValue.hasLingerTimeout() ? defaultValue.getLingerTimeout() : null))).andThen(ConfigConverters.applyIfNotNull(SocketSettings::withImplReadTimeout, config.get(ConfigConverters.ofDuration(), "implReadTimeout", defaultValue.hasImplReadTimeout() ? defaultValue.getImplReadTimeout() : null))).andThen(ConfigConverters.applyIfNotNull(SocketSettings::withImplWriteTimeout, config.get(ConfigConverters.ofDuration(), "implWriteTimeout", defaultValue.hasImplWriteTimeout() ? defaultValue.getImplWriteTimeout() : null))).andThen(ConfigConverters.applyIfNotNull(SocketSettings::withImplReadBufferSize, config.get(ConfigConverters.ofMemSize(), "implReadBufferSize", defaultValue.hasReadBufferSize() ? defaultValue.getImplReadBufferSize() : null))).apply(SocketSettings.create());
            }
        };
    }

    public static ConfigConverter<DatagramSocketSettings> ofDatagramSocketSettings() {
        return new ComplexConfigConverter<DatagramSocketSettings>(DatagramSocketSettings.create()){

            @Override
            protected DatagramSocketSettings provide(Config config, DatagramSocketSettings defaultValue) {
                return (DatagramSocketSettings)Function.identity().andThen(ConfigConverters.applyIfNotNull(DatagramSocketSettings::withReceiveBufferSize, config.get(ConfigConverters.ofMemSize(), "receiveBufferSize", defaultValue.hasReceiveBufferSize() ? defaultValue.getReceiveBufferSize() : null))).andThen(ConfigConverters.applyIfNotNull(DatagramSocketSettings::withSendBufferSize, config.get(ConfigConverters.ofMemSize(), "sendBufferSize", defaultValue.hasSendBufferSize() ? defaultValue.getSendBufferSize() : null))).andThen(ConfigConverters.applyIfNotNull(DatagramSocketSettings::withReuseAddress, config.get(ConfigConverters.ofBoolean(), "reuseAddress", defaultValue.hasReuseAddress() ? Boolean.valueOf(defaultValue.getReuseAddress()) : null))).andThen(ConfigConverters.applyIfNotNull(DatagramSocketSettings::withBroadcast, config.get(ConfigConverters.ofBoolean(), "broadcast", defaultValue.hasBroadcast() ? Boolean.valueOf(defaultValue.getBroadcast()) : null))).apply(DatagramSocketSettings.create());
            }
        };
    }

    public static ConfigConverter<FatalErrorHandler> ofFatalErrorHandler() {
        return new ConfigConverter<FatalErrorHandler>(){

            @Override
            @NotNull
            public FatalErrorHandler get(Config config) {
                switch (config.getValue()) {
                    case "rethrow": {
                        return FatalErrorHandler.rethrow();
                    }
                    case "ignore": {
                        return FatalErrorHandler.ignore();
                    }
                    case "halt": {
                        return FatalErrorHandler.halt();
                    }
                    case "haltOnError": {
                        return FatalErrorHandler.haltOnError();
                    }
                    case "haltOnVirtualMachineError": {
                        return FatalErrorHandler.haltOnVirtualMachineError();
                    }
                    case "haltOnOutOfMemoryError": {
                        return FatalErrorHandler.haltOnOutOfMemoryError();
                    }
                    case "rethrowOn": {
                        return FatalErrorHandler.rethrowOn((Predicate)ConfigConverters.toThrowablePredicate(config.get(OF_CLASSES, "whitelist", Collections.emptyList()), config.get(OF_CLASSES, "blacklist", Collections.emptyList())));
                    }
                    case "haltOn": {
                        return FatalErrorHandler.haltOn((Predicate)ConfigConverters.toThrowablePredicate(config.get(OF_CLASSES, "whitelist", Collections.emptyList()), config.get(OF_CLASSES, "blacklist", Collections.emptyList())));
                    }
                    case "logging": {
                        return FatalErrorHandler.logging();
                    }
                    case "loggingToSystemOut": {
                        return FatalErrorHandler.loggingToSystemOut();
                    }
                    case "loggingToSystemErr": {
                        return FatalErrorHandler.loggingToSystemErr();
                    }
                    case "loggingToEventloop": {
                        FatalErrorHandler logging = FatalErrorHandler.logging();
                        return (e, context) -> {
                            Eventloop eventloop = Eventloop.getCurrentEventloopOrNull();
                            if (eventloop != null) {
                                eventloop.logFatalError(e, context);
                            } else {
                                logging.handle(e, context);
                            }
                        };
                    }
                }
                throw new IllegalArgumentException("No fatal error handler named " + config.getValue() + " exists!");
            }

            @Override
            public FatalErrorHandler get(Config config, FatalErrorHandler defaultValue) {
                if (config.isEmpty()) {
                    return defaultValue;
                }
                return this.get(config);
            }
        };
    }

    private static Predicate<Throwable> toThrowablePredicate(List<Class<?>> whiteList, List<Class<?>> blackList) {
        return e -> ConfigConverters.matchesAny(e.getClass(), whiteList) && !ConfigConverters.matchesAny(e.getClass(), blackList);
    }

    private static boolean matchesAny(Class<?> c, List<Class<?>> list) {
        return list.stream().anyMatch(cl -> cl.isAssignableFrom(c));
    }

    public static ConfigConverter<EventloopTaskScheduler.Schedule> ofEventloopTaskSchedule() {
        return new ConfigConverter<EventloopTaskScheduler.Schedule>(){

            @Override
            @NotNull
            public EventloopTaskScheduler.Schedule get(Config config) {
                switch (config.get("type")) {
                    case "immediate": {
                        return EventloopTaskScheduler.Schedule.immediate();
                    }
                    case "delay": {
                        return EventloopTaskScheduler.Schedule.ofDelay((Duration)config.get(ConfigConverters.ofDuration(), "value"));
                    }
                    case "interval": {
                        return EventloopTaskScheduler.Schedule.ofInterval((Duration)config.get(ConfigConverters.ofDuration(), "value"));
                    }
                    case "period": {
                        return EventloopTaskScheduler.Schedule.ofPeriod((Duration)config.get(ConfigConverters.ofDuration(), "value"));
                    }
                }
                throw new IllegalArgumentException("No eventloop task schedule type named " + config.getValue() + " exists!");
            }

            @Override
            public EventloopTaskScheduler.Schedule get(Config config, EventloopTaskScheduler.Schedule defaultValue) {
                if (config.isEmpty()) {
                    return defaultValue;
                }
                return this.get(config);
            }
        };
    }

    public static ConfigConverter<RetryPolicy> ofRetryPolicy() {
        return new ConfigConverter<RetryPolicy>(){

            @Override
            @NotNull
            public RetryPolicy get(Config config) {
                RetryPolicy retryPolicy;
                if (!config.hasValue() || config.getValue().equals("no")) {
                    return RetryPolicy.noRetry();
                }
                switch (config.getValue()) {
                    case "immediate": {
                        retryPolicy = RetryPolicy.immediateRetry();
                        break;
                    }
                    case "fixedDelay": {
                        retryPolicy = RetryPolicy.fixedDelay((long)config.get(ConfigConverters.ofDuration(), "delay").toMillis());
                        break;
                    }
                    case "exponentialBackoff": {
                        retryPolicy = RetryPolicy.exponentialBackoff((long)config.get(ConfigConverters.ofDuration(), "initialDelay").toMillis(), (long)config.get(ConfigConverters.ofDuration(), "maxDelay").toMillis(), (double)config.get(ConfigConverters.ofDouble(), "exponent", 2.0));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No retry policy named " + config.getValue() + " exists!");
                    }
                }
                int maxRetryCount = config.get(ConfigConverters.ofInteger(), "maxRetryCount", Integer.MAX_VALUE);
                if (maxRetryCount != Integer.MAX_VALUE) {
                    retryPolicy = retryPolicy.withMaxTotalRetryCount(maxRetryCount);
                }
                Duration max = Duration.ofSeconds(Long.MAX_VALUE);
                Duration maxRetryTimeout = config.get(ConfigConverters.ofDuration(), "maxRetryTimeout", max);
                if (!maxRetryTimeout.equals(max)) {
                    retryPolicy = retryPolicy.withMaxTotalRetryTimeout(maxRetryTimeout);
                }
                return retryPolicy;
            }

            @Override
            public RetryPolicy get(Config config, RetryPolicy defaultValue) {
                if (config.isEmpty()) {
                    return defaultValue;
                }
                return this.get(config);
            }
        };
    }

    public static ConfigConverter<ThrottlingController> ofThrottlingController() {
        return new ComplexConfigConverter<ThrottlingController>(ThrottlingController.create()){

            @Override
            protected ThrottlingController provide(Config config, ThrottlingController defaultValue) {
                return ThrottlingController.create().withTargetTime(config.get(ConfigConverters.ofDuration(), "targetTime", defaultValue.getTargetTime())).withGcTime(config.get(ConfigConverters.ofDuration(), "gcTime", defaultValue.getGcTime())).withSmoothingWindow(config.get(ConfigConverters.ofDuration(), "smoothingWindow", defaultValue.getSmoothingWindow())).withThrottlingDecrease(config.get(ConfigConverters.ofDouble(), "throttlingDecrease", defaultValue.getThrottlingDecrease()).doubleValue()).withInitialKeysPerSecond(config.get(ConfigConverters.ofDouble(), "initialKeysPerSecond", 100.0).doubleValue()).withInitialThrottling(config.get(ConfigConverters.ofDouble(), "initialThrottling", 0.0).doubleValue());
            }
        };
    }

    public static ExecutorService getExecutor(Config config) {
        int corePoolSize = config.get(ConfigConverters.ofInteger().withConstraint(x -> x >= 0), "corePoolSize", 0);
        int maxPoolSize = config.get(ConfigConverters.ofInteger().withConstraint(x -> x >= corePoolSize), "maxPoolSize", Integer.MAX_VALUE);
        int keepAlive = config.get(ConfigConverters.ofInteger().withConstraint(x -> x >= 0), "keepAliveSeconds", 60);
        int queueSize = config.get(ConfigConverters.ofInteger().withConstraint(x -> x >= 0), "queueSize", Integer.MAX_VALUE);
        AbstractQueue queue = queueSize == 0 ? new SynchronousQueue() : (queueSize == Integer.MAX_VALUE ? new LinkedBlockingQueue() : new ArrayBlockingQueue(queueSize));
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize == 0 ? Integer.MAX_VALUE : maxPoolSize, keepAlive, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue));
    }

    public static ConfigConverter<ExecutorService> ofExecutor() {
        return new ConfigConverter<ExecutorService>(){

            @Override
            @NotNull
            public ExecutorService get(Config config) {
                return ConfigConverters.getExecutor(config);
            }

            @Override
            public ExecutorService get(Config config, ExecutorService defaultValue) {
                throw new IllegalArgumentException("Should not use executor config converter with default value");
            }
        };
    }

    public static <T, V> UnaryOperator<T> apply(BiFunction<T, ? super V, T> modifier, V value) {
        return instance -> modifier.apply((Object)instance, (Object)value);
    }

    public static <T, V> UnaryOperator<T> applyIf(BiFunction<T, ? super V, T> modifier, V value, Predicate<? super V> predicate) {
        return instance -> {
            if (!predicate.test((Object)value)) {
                return instance;
            }
            return modifier.apply((Object)instance, (Object)value);
        };
    }

    public static <T, V> UnaryOperator<T> applyIfNotNull(BiFunction<T, ? super V, T> modifier, V value) {
        return ConfigConverters.applyIf(modifier, value, Objects::nonNull);
    }
}

