/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp;

import io.activej.async.function.AsyncSupplier;
import io.activej.async.process.AsyncCloseable;
import io.activej.async.process.AsyncExecutor;
import io.activej.bytebuf.ByteBuf;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.recycle.Recyclers;
import io.activej.csp.AbstractChannelSupplier;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelInput;
import io.activej.csp.ChannelSuppliers;
import io.activej.csp.dsl.ChannelSupplierTransformer;
import io.activej.csp.queue.ChannelQueue;
import io.activej.eventloop.Eventloop;
import io.activej.net.socket.tcp.AsyncTcpSocket;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ChannelSupplier<T>
extends AsyncCloseable {
    @NotNull
    public Promise<T> get();

    public static <T> ChannelSupplier<T> of(AsyncSupplier<T> supplier) {
        return ChannelSupplier.of(supplier, null);
    }

    public static <T> ChannelSupplier<T> of(final AsyncSupplier<T> supplier, @Nullable AsyncCloseable closeable) {
        return new AbstractChannelSupplier<T>(closeable){

            @Override
            protected Promise<T> doGet() {
                return supplier.get();
            }
        };
    }

    public static <T> ChannelSupplier<T> ofConsumer(Consumer<ChannelConsumer<T>> consumer, ChannelQueue<T> queue) {
        consumer.accept(queue.getConsumer());
        return queue.getSupplier();
    }

    public static <T> ChannelSupplier<T> ofSupplier(Supplier<Promise<T>> supplier) {
        return ChannelSupplier.of(supplier::get);
    }

    public static <T> ChannelSupplier<T> of() {
        return new ChannelSuppliers.ChannelSupplierEmpty();
    }

    public static <T> ChannelSupplier<T> of(T value) {
        return new ChannelSuppliers.ChannelSupplierOfValue<T>(value);
    }

    @SafeVarargs
    public static <T> ChannelSupplier<T> of(T ... values) {
        return ChannelSupplier.ofList(Arrays.asList(values));
    }

    public static <T> ChannelSupplier<T> ofException(Exception e) {
        return new ChannelSuppliers.ChannelSupplierOfException(e);
    }

    public static <T> ChannelSupplier<T> ofList(List<? extends T> list) {
        return new ChannelSuppliers.ChannelSupplierOfIterator<T>(list.iterator(), true);
    }

    public static <T> ChannelSupplier<T> ofStream(Stream<? extends T> stream) {
        return ChannelSupplier.ofIterator(stream.iterator());
    }

    public static <T> ChannelSupplier<T> ofIterator(Iterator<? extends T> iterator) {
        return new ChannelSuppliers.ChannelSupplierOfIterator<T>(iterator, false);
    }

    public static ChannelSupplier<ByteBuf> ofSocket(AsyncTcpSocket socket) {
        return ChannelSuppliers.prefetch(ChannelSupplier.of(() -> ((AsyncTcpSocket)socket).read(), (AsyncCloseable)socket));
    }

    public static <T> ChannelSupplier<T> ofPromise(final Promise<? extends ChannelSupplier<T>> promise) {
        if (promise.isResult()) {
            return (ChannelSupplier)promise.getResult();
        }
        return new AbstractChannelSupplier<T>(){
            ChannelSupplier<T> supplier;
            Exception exception;

            @Override
            protected Promise<T> doGet() {
                if (this.supplier != null) {
                    return this.supplier.get();
                }
                return promise.then(supplier -> {
                    this.supplier = supplier;
                    return supplier.get();
                });
            }

            protected void onClosed(@NotNull Exception e) {
                this.exception = e;
                promise.whenResult(supplier -> supplier.closeEx(e));
            }
        };
    }

    public static <T> ChannelSupplier<T> ofAnotherEventloop(final @NotNull Eventloop anotherEventloop, final @NotNull ChannelSupplier<T> anotherEventloopSupplier) {
        if (Eventloop.getCurrentEventloop() == anotherEventloop) {
            return anotherEventloopSupplier;
        }
        return new AbstractChannelSupplier<T>(){

            @Override
            protected Promise<T> doGet() {
                SettablePromise promise = new SettablePromise();
                this.eventloop.startExternalTask();
                anotherEventloop.execute(() -> anotherEventloopSupplier.get().run((item, e) -> {
                    this.eventloop.execute(() -> promise.accept(item, e));
                    this.eventloop.completeExternalTask();
                }));
                return promise;
            }

            protected void onClosed(@NotNull Exception e) {
                this.eventloop.startExternalTask();
                anotherEventloop.execute(() -> {
                    anotherEventloopSupplier.closeEx(e);
                    this.eventloop.completeExternalTask();
                });
            }
        };
    }

    public static <T> ChannelSupplier<T> ofLazyProvider(final Supplier<? extends ChannelSupplier<T>> provider) {
        return new AbstractChannelSupplier<T>(){
            private ChannelSupplier<T> supplier;

            @Override
            protected Promise<T> doGet() {
                if (this.supplier == null) {
                    this.supplier = (ChannelSupplier)provider.get();
                }
                return this.supplier.get();
            }

            protected void onClosed(@NotNull Exception e) {
                if (this.supplier != null) {
                    this.supplier.closeEx(e);
                }
            }
        };
    }

    default public <R> R transformWith(ChannelSupplierTransformer<T, R> fn) {
        return fn.transform(this);
    }

    default public ChannelSupplier<T> async() {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelSupplier.this.get().async();
            }
        };
    }

    default public ChannelSupplier<T> withExecutor(final AsyncExecutor asyncExecutor) {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return asyncExecutor.execute(ChannelSupplier.this::get);
            }
        };
    }

    default public ChannelSupplier<T> peek(final Consumer<? super T> fn) {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelSupplier.this.get().whenResult(Objects::nonNull, fn::accept);
            }
        };
    }

    default public <V> ChannelSupplier<V> map(final FunctionEx<? super @NotNull T, ? extends V> fn) {
        return new AbstractChannelSupplier<V>(this){

            @Override
            protected Promise<V> doGet() {
                return ChannelSupplier.this.get().mapIfNonNull(value -> {
                    try {
                        return fn.apply(value);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)fn);
                        ChannelSupplier.this.closeEx(ex);
                        throw ex;
                    }
                });
            }
        };
    }

    default public <V> ChannelSupplier<V> mapAsync(final Function<? super @NotNull T, Promise<V>> fn) {
        return new AbstractChannelSupplier<V>(this){

            @Override
            protected Promise<V> doGet() {
                return ChannelSupplier.this.get().thenIfNonNull(fn::apply);
            }
        };
    }

    default public ChannelSupplier<T> filter(final Predicate<? super T> predicate) {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                Promise promise;
                while ((promise = ChannelSupplier.this.get()).isResult()) {
                    Object value2 = promise.getResult();
                    if (value2 == null || predicate.test(value2)) {
                        return promise;
                    }
                    Recyclers.recycle((Object)value2);
                }
                return promise.thenIf(value -> value != null && !predicate.test(value), value -> {
                    Recyclers.recycle((Object)value);
                    return this.get();
                });
            }
        };
    }

    default public ChannelSupplier<T> until(final Predicate<? super T> predicate) {
        return new AbstractChannelSupplier<T>(this){
            boolean stop;
            {
                super(closeable);
                this.stop = false;
            }

            @Override
            protected Promise<T> doGet() {
                if (this.stop) {
                    return Promise.of(null);
                }
                return ChannelSupplier.this.get().mapIfNonNull(value -> {
                    if (predicate.test(value)) {
                        this.stop = true;
                    }
                    return value;
                });
            }
        };
    }

    default public ChannelSupplier<T> lenient() {
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelSupplier.this.get().map((value, e) -> value);
            }
        };
    }

    default public Promise<Void> streamTo(ChannelConsumer<T> consumer) {
        return ChannelSuppliers.streamTo(this, consumer);
    }

    default public Promise<Void> streamTo(Promise<? extends ChannelConsumer<T>> consumer) {
        return ChannelSuppliers.streamTo(this, ChannelConsumer.ofPromise(consumer));
    }

    default public Promise<Void> bindTo(ChannelInput<T> to) {
        return to.set(this);
    }

    default public <A, R> Promise<R> toCollector(Collector<T, A, R> collector) {
        return ChannelSuppliers.collect(this, collector.supplier().get(), BiConsumerEx.of(collector.accumulator()), FunctionEx.of(collector.finisher()));
    }

    default public Promise<List<T>> toList() {
        return this.toCollector(Collectors.toList());
    }

    default public ChannelSupplier<T> withEndOfStream(UnaryOperator<Promise<Void>> fn) {
        final SettablePromise endOfStream = new SettablePromise();
        final Promise newEndOfStream = (Promise)fn.apply((Promise<Void>)endOfStream);
        return new AbstractChannelSupplier<T>(this){

            @Override
            protected Promise<T> doGet() {
                return ChannelSupplier.this.get().then((item, e) -> {
                    if (e == null) {
                        if (item != null) {
                            return Promise.of((Object)item);
                        }
                        endOfStream.trySet(null);
                    } else {
                        endOfStream.trySetException(e);
                    }
                    return newEndOfStream;
                });
            }

            protected void onClosed(@NotNull Exception e) {
                endOfStream.trySetException(e);
            }
        };
    }
}

