/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.binary;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufs;
import io.activej.common.exception.MalformedDataException;
import io.activej.csp.binary.ByteBufsDecoder;
import io.activej.csp.binary.DecoderFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ByteBufsCodec<I, O> {
    public ByteBuf encode(O var1);

    @Nullable
    public I tryDecode(ByteBufs var1) throws MalformedDataException;

    @NotNull
    default public <I1, O1> ByteBufsCodec<I1, O1> andThen(final DecoderFunction<? super I, ? extends I1> decoder, final Function<? super O1, ? extends O> encoder) {
        return new ByteBufsCodec<I1, O1>(){

            @Override
            public ByteBuf encode(O1 item) {
                return ByteBufsCodec.this.encode(encoder.apply(item));
            }

            @Override
            @Nullable
            public I1 tryDecode(ByteBufs bufs) throws MalformedDataException {
                Object maybeResult = ByteBufsCodec.this.tryDecode(bufs);
                if (maybeResult == null) {
                    return null;
                }
                return decoder.decode(maybeResult);
            }
        };
    }

    @NotNull
    public static ByteBufsCodec<ByteBuf, ByteBuf> ofDelimiter(final ByteBufsDecoder<ByteBuf> delimiterIn, final UnaryOperator<ByteBuf> delimiterOut) {
        return new ByteBufsCodec<ByteBuf, ByteBuf>(){

            @Override
            public ByteBuf encode(ByteBuf buf) {
                return (ByteBuf)delimiterOut.apply(buf);
            }

            @Override
            @Nullable
            public ByteBuf tryDecode(ByteBufs bufs) throws MalformedDataException {
                return (ByteBuf)delimiterIn.tryDecode(bufs);
            }
        };
    }
}

