/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.file;

import io.activej.async.exception.AsyncCloseException;
import io.activej.async.file.AsyncFileService;
import io.activej.async.file.ExecutorAsyncFileService;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.initializer.WithInitializer;
import io.activej.csp.AbstractChannelSupplier;
import io.activej.promise.Promise;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelFileReader
extends AbstractChannelSupplier<ByteBuf>
implements WithInitializer<ChannelFileReader> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFileReader.class);
    private static final OpenOption[] DEFAULT_OPTIONS = new OpenOption[]{StandardOpenOption.READ};
    public static final MemSize DEFAULT_BUFFER_SIZE = MemSize.kilobytes((long)8L);
    private final AsyncFileService fileService;
    private final FileChannel channel;
    private int bufferSize = DEFAULT_BUFFER_SIZE.toInt();
    private long position = 0L;
    private long limit = Long.MAX_VALUE;

    private ChannelFileReader(AsyncFileService fileService, FileChannel channel) {
        this.fileService = fileService;
        this.channel = channel;
    }

    public static ChannelFileReader create(Executor executor, FileChannel channel) {
        return ChannelFileReader.create((AsyncFileService)new ExecutorAsyncFileService(executor), channel);
    }

    public static ChannelFileReader create(AsyncFileService fileService, FileChannel channel) {
        return new ChannelFileReader(fileService, channel);
    }

    public static Promise<ChannelFileReader> open(Executor executor, Path path) {
        return ChannelFileReader.open(executor, path, DEFAULT_OPTIONS);
    }

    public static Promise<ChannelFileReader> open(Executor executor, Path path, OpenOption ... openOptions) {
        Checks.checkArgument((boolean)Arrays.asList(openOptions).contains(StandardOpenOption.READ), (Object)"'READ' option is not present");
        return Promise.ofBlocking((Executor)executor, () -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new FileSystemException(path.toString(), null, "Is a directory");
            }
            return FileChannel.open(path, openOptions);
        }).map(channel -> ChannelFileReader.create(executor, channel));
    }

    public static ChannelFileReader openBlocking(Executor executor, Path path) throws IOException {
        return ChannelFileReader.openBlocking(executor, path, DEFAULT_OPTIONS);
    }

    public static ChannelFileReader openBlocking(Executor executor, Path path, OpenOption ... openOptions) throws IOException {
        Checks.checkArgument((boolean)Arrays.asList(openOptions).contains(StandardOpenOption.READ), (Object)"'READ' option is not present");
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new FileSystemException(path.toString(), null, "Is a directory");
        }
        FileChannel channel = FileChannel.open(path, openOptions);
        return ChannelFileReader.create(executor, channel);
    }

    public ChannelFileReader withBufferSize(MemSize bufferSize) {
        return this.withBufferSize(bufferSize.toInt());
    }

    public ChannelFileReader withBufferSize(int bufferSize) {
        Checks.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Buffer size cannot be less than or equal to zero");
        this.bufferSize = bufferSize;
        return this;
    }

    public ChannelFileReader withOffset(long offset) {
        Checks.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"Offset cannot be less than zero");
        this.position = offset;
        return this;
    }

    public ChannelFileReader withLimit(long limit) {
        Checks.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"Limit cannot be less than zero");
        this.limit = limit;
        return this;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    protected Promise<ByteBuf> doGet() {
        if (this.limit == 0L) {
            this.close();
            return Promise.of(null);
        }
        ByteBuf buf = ByteBufPool.allocateExact((int)((int)Math.min((long)this.bufferSize, this.limit)));
        return this.fileService.read(this.channel, this.position, buf.array(), buf.head(), buf.writeRemaining()).then(bytesRead -> {
            if (bytesRead == 0) {
                buf.recycle();
                this.close();
                return Promise.of(null);
            }
            buf.moveTail(Math.toIntExact(bytesRead.intValue()));
            this.position += (long)bytesRead.intValue();
            if (this.limit != Long.MAX_VALUE) {
                this.limit -= (long)bytesRead.intValue();
            }
            return Promise.of((Object)buf);
        }, e -> {
            buf.recycle();
            this.closeEx((Exception)e);
            return Promise.ofException((Exception)this.getException());
        });
    }

    protected void onClosed(@NotNull Exception e) {
        try {
            if (!this.channel.isOpen()) {
                throw new AsyncCloseException("File has been closed");
            }
            this.channel.close();
            logger.trace("{}: closed file", (Object)this);
        }
        catch (AsyncCloseException | IOException e1) {
            logger.error("{}: failed to close file", (Object)this, (Object)e1);
        }
    }

    public String toString() {
        return "ChannelFileReader{pos=" + this.position + (this.limit == Long.MAX_VALUE ? "" : ", limit=" + this.limit) + '}';
    }
}

