/*
 * Decompiled with CFR 0.152.
 */
package io.activej.csp.queue;

import io.activej.bytebuf.ByteBuf;
import io.activej.common.MemSize;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.tuple.Tuple2;
import io.activej.csp.file.ChannelFileReader;
import io.activej.csp.file.ChannelFileWriter;
import io.activej.csp.queue.ChannelQueue;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelFileBuffer
implements ChannelQueue<ByteBuf>,
WithInitializer<ChannelFileBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFileBuffer.class);
    private final ChannelFileReader reader;
    private final ChannelFileWriter writer;
    private final Executor executor;
    private final Path path;
    @Nullable
    private SettablePromise<ByteBuf> take;
    private boolean finished = false;
    @Nullable
    private Exception exception;

    private ChannelFileBuffer(ChannelFileReader reader, ChannelFileWriter writer, Executor executor, Path path) {
        this.reader = reader;
        this.writer = writer;
        this.executor = executor;
        this.path = path;
    }

    public static Promise<ChannelFileBuffer> create(Executor executor, Path filePath) {
        return ChannelFileBuffer.create(executor, filePath, null);
    }

    public static Promise<ChannelFileBuffer> create(Executor executor, Path path, @Nullable MemSize limit) {
        return Promise.ofBlocking((Executor)executor, () -> {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            FileChannel writerChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            FileChannel readerChannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ);
            return new Tuple2((Object)writerChannel, (Object)readerChannel);
        }).map(tuple2 -> {
            ChannelFileWriter writer = ChannelFileWriter.create(executor, (FileChannel)tuple2.getValue1());
            ChannelFileReader reader = ChannelFileReader.create(executor, (FileChannel)tuple2.getValue2());
            if (limit != null) {
                reader.withLimit(limit.toLong());
            }
            return new ChannelFileBuffer(reader, writer, executor, path);
        });
    }

    @Override
    public Promise<Void> put(@Nullable ByteBuf item) {
        if (this.exception != null) {
            return Promise.ofException((Exception)this.exception);
        }
        if (item == null) {
            this.finished = true;
        }
        if (this.take == null) {
            return this.writer.accept(item);
        }
        SettablePromise<ByteBuf> promise = this.take;
        this.take = null;
        promise.set((Object)item);
        return item == null ? this.writer.accept(null) : Promise.complete();
    }

    @Override
    public Promise<ByteBuf> take() {
        SettablePromise promise;
        if (this.exception != null) {
            return Promise.ofException((Exception)this.exception);
        }
        if (!this.isExhausted()) {
            return this.reader.get();
        }
        if (this.finished) {
            return Promise.of(null);
        }
        this.take = promise = new SettablePromise();
        return promise;
    }

    @Override
    public boolean isSaturated() {
        return false;
    }

    @Override
    public boolean isExhausted() {
        return this.reader.getPosition() >= this.writer.getPosition();
    }

    public void closeEx(@NotNull Exception e) {
        if (this.exception != null) {
            return;
        }
        this.exception = e;
        this.writer.closeEx(e);
        this.reader.closeEx(e);
        if (this.take != null) {
            this.take.setException(e);
            this.take = null;
        }
        this.executor.execute(() -> {
            try {
                Files.deleteIfExists(this.path);
            }
            catch (IOException io) {
                logger.error("failed to cleanup channel buffer file " + this.path, (Throwable)io);
            }
        });
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }
}

