/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream;

import io.activej.datastream.ForwardingStreamConsumer;
import io.activej.datastream.StreamConsumer;
import io.activej.datastream.StreamSupplier;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

public abstract class ForwardingStreamSupplier<T>
implements StreamSupplier<T> {
    protected final StreamSupplier<T> supplier;

    protected ForwardingStreamSupplier(StreamSupplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public Promise<Void> streamTo(@NotNull StreamConsumer<T> consumer) {
        return this.supplier.streamTo(new ForwardingStreamConsumer<T>(consumer){

            @Override
            public void consume(@NotNull StreamSupplier<T> streamSupplier) {
                super.consume(ForwardingStreamSupplier.this);
            }
        });
    }

    @Override
    public Promise<Void> getAcknowledgement() {
        return this.supplier.getAcknowledgement();
    }

    @Override
    public void updateDataAcceptor() {
        this.supplier.updateDataAcceptor();
    }

    @Override
    public Promise<Void> getEndOfStream() {
        return this.supplier.getEndOfStream();
    }

    public void closeEx(@NotNull Exception e) {
        this.supplier.closeEx(e);
    }
}

