/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream;

import io.activej.common.initializer.WithInitializer;
import io.activej.datastream.AbstractStreamConsumer;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.ArrayList;
import java.util.List;

public final class StreamConsumerToList<T>
extends AbstractStreamConsumer<T>
implements WithInitializer<StreamConsumerToList<T>> {
    private final SettablePromise<List<T>> resultPromise = new SettablePromise();
    private final List<T> list;

    private StreamConsumerToList(List<T> list) {
        this.list = list;
    }

    public static <T> StreamConsumerToList<T> create() {
        return StreamConsumerToList.create(new ArrayList());
    }

    public static <T> StreamConsumerToList<T> create(List<T> list) {
        return new StreamConsumerToList<T>(list);
    }

    public Promise<List<T>> getResult() {
        return this.resultPromise;
    }

    public List<T> getList() {
        return this.list;
    }

    @Override
    protected void onInit() {
        this.resultPromise.whenResult(this::acknowledge);
    }

    @Override
    protected void onStarted() {
        this.resume(this.list::add);
    }

    @Override
    protected void onEndOfStream() {
        this.resultPromise.set(this.list);
    }

    @Override
    protected void onError(Exception e) {
        this.resultPromise.setException(e);
    }
}

