/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream;

import io.activej.common.recycle.Recyclers;
import io.activej.datastream.StreamConsumer;
import io.activej.promise.Promise;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class StreamConsumerWithResult<T, X> {
    @NotNull
    private final StreamConsumer<T> consumer;
    @NotNull
    private final Promise<X> result;

    private StreamConsumerWithResult(@NotNull StreamConsumer<T> consumer, @NotNull Promise<X> result) {
        this.consumer = consumer;
        this.result = result;
    }

    public static <T, X> StreamConsumerWithResult<T, X> of(StreamConsumer<T> consumer, Promise<X> result) {
        return new StreamConsumerWithResult<T, X>(consumer, result);
    }

    public StreamConsumerWithResult<T, X> sanitize() {
        return new StreamConsumerWithResult<T, X>(this.consumer, this.consumer.getAcknowledgement().combine(this.result.whenException(arg_0 -> this.consumer.closeEx(arg_0)), ($, v) -> v).async());
    }

    public <T1, X1> StreamConsumerWithResult<T1, X1> transform(Function<StreamConsumer<T>, StreamConsumer<T1>> consumerTransformer, Function<Promise<X>, Promise<X1>> resultTransformer) {
        return new StreamConsumerWithResult<T1, X1>(consumerTransformer.apply(this.consumer), resultTransformer.apply(this.result));
    }

    public <T1> StreamConsumerWithResult<T1, X> transformConsumer(Function<StreamConsumer<T>, StreamConsumer<T1>> consumerTransformer) {
        return this.transform(consumerTransformer, Function.identity());
    }

    public <X1> StreamConsumerWithResult<T, X1> transformResult(Function<Promise<X>, Promise<X1>> resultTransformer) {
        return this.transform(Function.identity(), resultTransformer);
    }

    public static <T, X> StreamConsumerWithResult<T, X> ofPromise(Promise<StreamConsumerWithResult<T, X>> promise) {
        return StreamConsumerWithResult.of(StreamConsumer.ofPromise(promise.map(StreamConsumerWithResult::getConsumer)), promise.then(StreamConsumerWithResult::getResult));
    }

    @NotNull
    public StreamConsumer<T> getConsumer() {
        return this.consumer;
    }

    @NotNull
    public Promise<X> getResult() {
        return this.result;
    }

    static {
        Recyclers.register(StreamConsumerWithResult.class, item -> {
            Recyclers.recycle(item.consumer);
            Recyclers.recycle(item.result);
        });
    }
}

