/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream;

import io.activej.async.process.AsyncCloseable;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.SupplierEx;
import io.activej.csp.ChannelSupplier;
import io.activej.datastream.AbstractStreamSupplier;
import io.activej.datastream.ForwardingStreamSupplier;
import io.activej.datastream.StreamConsumer;
import io.activej.datastream.StreamConsumerWithResult;
import io.activej.datastream.StreamConsumers;
import io.activej.datastream.StreamSuppliers;
import io.activej.datastream.processor.StreamSupplierTransformer;
import io.activej.datastream.processor.StreamTransformer;
import io.activej.eventloop.Eventloop;
import io.activej.promise.Promise;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface StreamSupplier<T>
extends AsyncCloseable {
    public Promise<Void> streamTo(@NotNull StreamConsumer<T> var1);

    public Promise<Void> getAcknowledgement();

    default public Promise<Void> streamTo(Promise<StreamConsumer<T>> consumerPromise) {
        return this.streamTo(StreamConsumer.ofPromise(consumerPromise));
    }

    public void updateDataAcceptor();

    public Promise<Void> getEndOfStream();

    default public boolean isComplete() {
        return this.getAcknowledgement().isComplete();
    }

    default public boolean isResult() {
        return this.getAcknowledgement().isResult();
    }

    default public boolean isException() {
        return this.getAcknowledgement().isException();
    }

    default public <X> Promise<X> streamTo(@NotNull StreamConsumerWithResult<T, X> consumerWithResult) {
        return this.streamTo(consumerWithResult.getConsumer()).then(consumerWithResult::getResult);
    }

    public static <T> StreamSupplier<T> ofConsumer(Consumer<StreamConsumer<T>> consumer) {
        StreamTransformer forwarder = StreamTransformer.identity();
        consumer.accept(forwarder.getInput());
        return forwarder.getOutput();
    }

    public static <T> StreamSupplier<T> idle() {
        return new StreamSuppliers.Idle();
    }

    public static <T> StreamSupplier<T> closing() {
        return new StreamSuppliers.Closing();
    }

    public static <T> StreamSupplier<T> closingWithError(Exception e) {
        return new StreamSuppliers.ClosingWithError(e);
    }

    @SafeVarargs
    public static <T> StreamSupplier<T> of(T ... items) {
        return new StreamSuppliers.OfIterator<T>(Arrays.asList(items).iterator());
    }

    public static <T> StreamSupplier<T> ofIterator(Iterator<T> iterator) {
        return new StreamSuppliers.OfIterator<T>(iterator);
    }

    public static <T> StreamSupplier<T> ofIterable(Iterable<T> iterable) {
        return new StreamSuppliers.OfIterator<T>(iterable.iterator());
    }

    public static <T> StreamSupplier<T> ofStream(Stream<T> stream) {
        return new StreamSuppliers.OfIterator(stream.iterator());
    }

    public static <T> StreamSupplier<T> ofSupplier(final SupplierEx<T> supplier) {
        return new AbstractStreamSupplier<T>(){

            @Override
            protected void onResumed() {
                while (this.isReady()) {
                    Object t;
                    try {
                        t = supplier.get();
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)supplier);
                        this.closeEx(ex);
                        break;
                    }
                    if (t != null) {
                        this.send(t);
                        continue;
                    }
                    this.sendEndOfStream();
                    break;
                }
            }
        };
    }

    public static <T> StreamSupplier<T> ofChannelSupplier(ChannelSupplier<T> supplier) {
        return new StreamSuppliers.OfChannelSupplier<T>(supplier);
    }

    public static <T> StreamSupplier<T> ofPromise(Promise<? extends StreamSupplier<T>> promise) {
        if (promise.isResult()) {
            return (StreamSupplier)promise.getResult();
        }
        return new StreamSuppliers.OfPromise(promise);
    }

    public static <T> StreamSupplier<T> ofAnotherEventloop(@NotNull Eventloop anotherEventloop, @NotNull StreamSupplier<T> anotherEventloopSupplier) {
        if (Eventloop.getCurrentEventloop() == anotherEventloop) {
            return anotherEventloopSupplier;
        }
        return new StreamSuppliers.OfAnotherEventloop<T>(anotherEventloop, anotherEventloopSupplier);
    }

    default public <R> R transformWith(StreamSupplierTransformer<T, R> fn) {
        return fn.transform(this);
    }

    public static <T> StreamSupplier<T> concat(Iterator<StreamSupplier<T>> iterator) {
        return new StreamSuppliers.Concat(ChannelSupplier.ofIterator(iterator));
    }

    public static <T> StreamSupplier<T> concat(ChannelSupplier<StreamSupplier<T>> supplier) {
        return new StreamSuppliers.Concat<T>(supplier);
    }

    public static <T> StreamSupplier<T> concat(List<StreamSupplier<T>> suppliers) {
        return new StreamSuppliers.Concat(ChannelSupplier.ofList(suppliers));
    }

    @SafeVarargs
    public static <T> StreamSupplier<T> concat(StreamSupplier<T> ... suppliers) {
        return StreamSupplier.concat(Arrays.asList(suppliers));
    }

    default public <A, R> Promise<R> toCollector(Collector<T, A, R> collector) {
        StreamConsumers.ToCollector<T, A, R> consumerToCollector = new StreamConsumers.ToCollector<T, A, R>(collector);
        this.streamTo(consumerToCollector);
        return consumerToCollector.getResult();
    }

    default public Promise<List<T>> toList() {
        return this.toCollector(Collectors.toList());
    }

    default public StreamSupplier<T> withEndOfStream(UnaryOperator<Promise<Void>> fn) {
        Promise suppliedEndOfStream;
        Promise<Void> endOfStream = this.getEndOfStream();
        if (endOfStream == (suppliedEndOfStream = (Promise)fn.apply(endOfStream))) {
            return this;
        }
        return new ForwardingStreamSupplier<T>(this){

            @Override
            public Promise<Void> getEndOfStream() {
                return suppliedEndOfStream;
            }
        };
    }
}

