/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream;

import io.activej.common.recycle.Recyclers;
import io.activej.common.tuple.Tuple2;
import io.activej.datastream.StreamConsumer;
import io.activej.datastream.StreamConsumerWithResult;
import io.activej.datastream.StreamSupplier;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class StreamSupplierWithResult<T, X> {
    @NotNull
    private final StreamSupplier<T> supplier;
    @NotNull
    private final Promise<X> result;

    private StreamSupplierWithResult(@NotNull StreamSupplier<T> supplier, @NotNull Promise<X> result) {
        this.supplier = supplier;
        this.result = result;
    }

    public static <T, X> StreamSupplierWithResult<T, X> of(StreamSupplier<T> supplier, Promise<X> result) {
        return new StreamSupplierWithResult<T, X>(supplier, result);
    }

    public Promise<X> streamTo(StreamConsumer<T> consumer) {
        return this.supplier.streamTo(consumer).then($ -> this.result);
    }

    public <Y> Promise<Tuple2<X, Y>> streamTo(StreamConsumerWithResult<T, Y> consumer) {
        return this.supplier.streamTo(consumer.getConsumer()).then(() -> Promises.toTuple(this.result, consumer.getResult()));
    }

    public StreamSupplierWithResult<T, X> sanitize() {
        return new StreamSupplierWithResult<T, X>(this.supplier, this.supplier.getEndOfStream().combine(this.result.whenException(arg_0 -> this.supplier.closeEx(arg_0)), ($, v) -> v).async());
    }

    public <T1, X1> StreamSupplierWithResult<T1, X1> transform(Function<StreamSupplier<T>, StreamSupplier<T1>> consumerTransformer, Function<Promise<X>, Promise<X1>> resultTransformer) {
        return new StreamSupplierWithResult<T1, X1>(consumerTransformer.apply(this.supplier), resultTransformer.apply(this.result));
    }

    public <T1> StreamSupplierWithResult<T1, X> transformSupplier(Function<StreamSupplier<T>, StreamSupplier<T1>> consumerTransformer) {
        return this.transform(consumerTransformer, Function.identity());
    }

    public <X1> StreamSupplierWithResult<T, X1> transformResult(Function<Promise<X>, Promise<X1>> resultTransformer) {
        return this.transform(Function.identity(), resultTransformer);
    }

    public static <T, X> StreamSupplierWithResult<T, X> ofPromise(Promise<StreamSupplierWithResult<T, X>> promise) {
        if (promise.isResult()) {
            return (StreamSupplierWithResult)promise.getResult();
        }
        return StreamSupplierWithResult.of(StreamSupplier.ofPromise(promise.map(StreamSupplierWithResult::getSupplier)), promise.then(StreamSupplierWithResult::getResult));
    }

    @NotNull
    public StreamSupplier<T> getSupplier() {
        return this.supplier;
    }

    @NotNull
    public Promise<X> getResult() {
        return this.result;
    }

    static {
        Recyclers.register(StreamSupplierWithResult.class, item -> {
            Recyclers.recycle(item.supplier);
            Recyclers.recycle(item.result);
        });
    }
}

