/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream.processor;

import io.activej.datastream.StreamDataAcceptor;
import java.util.function.BinaryOperator;

public final class StreamReducers {
    public static <K, T> Reducer<K, T, T, Void> deduplicateReducer() {
        return new DeduplicateReducer();
    }

    public static <K, T> Reducer<K, T, T, Void> mergeReducer() {
        return new MergeReducer();
    }

    public static class DeduplicateReducer<K, T>
    implements Reducer<K, T, T, Void> {
        @Override
        public Void onFirstItem(StreamDataAcceptor<T> stream, K key, T firstValue) {
            stream.accept(firstValue);
            return null;
        }

        @Override
        public Void onNextItem(StreamDataAcceptor<T> stream, K key, T nextValue, Void accumulator) {
            return null;
        }

        @Override
        public void onComplete(StreamDataAcceptor<T> stream, K key, Void accumulator) {
        }
    }

    public static class MergeReducer<K, T>
    implements Reducer<K, T, T, Void> {
        @Override
        public Void onFirstItem(StreamDataAcceptor<T> stream, K key, T firstValue) {
            stream.accept(firstValue);
            return null;
        }

        @Override
        public Void onNextItem(StreamDataAcceptor<T> stream, K key, T nextValue, Void accumulator) {
            stream.accept(nextValue);
            return null;
        }

        @Override
        public void onComplete(StreamDataAcceptor<T> stream, K key, Void accumulator) {
        }
    }

    public static class BinaryAccumulatorReducer<K, T>
    implements Reducer<K, T, T, T> {
        private final BinaryOperator<T> combiner;

        public BinaryAccumulatorReducer(BinaryOperator<T> combiner) {
            this.combiner = combiner;
        }

        protected boolean filter(T value) {
            return true;
        }

        @Override
        public T onFirstItem(StreamDataAcceptor<T> stream, K key, T firstValue) {
            return firstValue;
        }

        @Override
        public T onNextItem(StreamDataAcceptor<T> stream, K key, T nextValue, T accumulator) {
            return (T)this.combiner.apply(accumulator, nextValue);
        }

        @Override
        public void onComplete(StreamDataAcceptor<T> stream, K key, T accumulator) {
            if (this.filter(accumulator)) {
                stream.accept(accumulator);
            }
        }
    }

    public static abstract class ReducerToAccumulator<K, I, A>
    extends ReducerToResult<K, I, A, A> {
        @Override
        public final A produceResult(A accumulator) {
            return accumulator;
        }
    }

    public static abstract class ReducerToResult<K, I, O, A> {
        public abstract A createAccumulator(K var1);

        public abstract A accumulate(A var1, I var2);

        public A combine(A accumulator, A anotherAccumulator) {
            throw new UnsupportedOperationException("can not combine two accumulators");
        }

        public abstract O produceResult(A var1);

        public final Reducer<K, I, O, A> inputToOutput() {
            return new InputToOutput(this);
        }

        public final Reducer<K, I, A, A> inputToAccumulator() {
            return new InputToAccumulator(this);
        }

        public final Reducer<K, A, O, A> accumulatorToOutput() {
            return new AccumulatorToOutput(this);
        }

        public final Reducer<K, A, A, A> accumulatorToAccumulator() {
            return new AccumulatorToAccumulator(this);
        }

        public static final class InputToOutput<K, I, O, A>
        implements Reducer<K, I, O, A> {
            private final ReducerToResult<K, I, O, A> reducerToResult;

            public InputToOutput(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            public ReducerToResult<K, I, O, A> getReducerToResult() {
                return this.reducerToResult;
            }

            @Override
            public A onFirstItem(StreamDataAcceptor<O> stream, K key, I firstValue) {
                A accumulator = this.reducerToResult.createAccumulator(key);
                return this.reducerToResult.accumulate(accumulator, firstValue);
            }

            @Override
            public A onNextItem(StreamDataAcceptor<O> stream, K key, I nextValue, A accumulator) {
                return this.reducerToResult.accumulate(accumulator, nextValue);
            }

            @Override
            public void onComplete(StreamDataAcceptor<O> stream, K key, A accumulator) {
                stream.accept(this.reducerToResult.produceResult(accumulator));
            }
        }

        public static final class InputToAccumulator<K, I, O, A>
        implements Reducer<K, I, A, A> {
            private final ReducerToResult<K, I, O, A> reducerToResult;

            public ReducerToResult<K, I, O, A> getReducerToResult() {
                return this.reducerToResult;
            }

            public InputToAccumulator(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            @Override
            public A onFirstItem(StreamDataAcceptor<A> stream, K key, I firstValue) {
                A accumulator = this.reducerToResult.createAccumulator(key);
                return this.reducerToResult.accumulate(accumulator, firstValue);
            }

            @Override
            public A onNextItem(StreamDataAcceptor<A> stream, K key, I nextValue, A accumulator) {
                return this.reducerToResult.accumulate(accumulator, nextValue);
            }

            @Override
            public void onComplete(StreamDataAcceptor<A> stream, K key, A accumulator) {
                stream.accept(accumulator);
            }
        }

        public static final class AccumulatorToOutput<K, I, O, A>
        implements Reducer<K, A, O, A> {
            private ReducerToResult<K, I, O, A> reducerToResult;

            public AccumulatorToOutput() {
            }

            public AccumulatorToOutput(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            public ReducerToResult<K, I, O, A> getReducerToResult() {
                return this.reducerToResult;
            }

            @Override
            public A onFirstItem(StreamDataAcceptor<O> stream, K key, A firstValue) {
                return firstValue;
            }

            @Override
            public A onNextItem(StreamDataAcceptor<O> stream, K key, A nextValue, A accumulator) {
                return this.reducerToResult.combine(accumulator, nextValue);
            }

            @Override
            public void onComplete(StreamDataAcceptor<O> stream, K key, A accumulator) {
                stream.accept(this.reducerToResult.produceResult(accumulator));
            }
        }

        public static final class AccumulatorToAccumulator<K, I, O, A>
        implements Reducer<K, A, A, A> {
            private final ReducerToResult<K, I, O, A> reducerToResult;

            public AccumulatorToAccumulator(ReducerToResult<K, I, O, A> reducerToResult) {
                this.reducerToResult = reducerToResult;
            }

            public ReducerToResult<K, I, O, A> getReducerToResult() {
                return this.reducerToResult;
            }

            @Override
            public A onFirstItem(StreamDataAcceptor<A> stream, K key, A firstValue) {
                return firstValue;
            }

            @Override
            public A onNextItem(StreamDataAcceptor<A> stream, K key, A nextValue, A accumulator) {
                return this.reducerToResult.combine(accumulator, nextValue);
            }

            @Override
            public void onComplete(StreamDataAcceptor<A> stream, K key, A accumulator) {
                stream.accept(accumulator);
            }
        }
    }

    public static interface Reducer<K, I, O, A> {
        public A onFirstItem(StreamDataAcceptor<O> var1, K var2, I var3);

        public A onNextItem(StreamDataAcceptor<O> var1, K var2, I var3, A var4);

        public void onComplete(StreamDataAcceptor<O> var1, K var2, A var3);
    }
}

