/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream.processor;

import io.activej.datastream.StreamConsumer;
import io.activej.datastream.StreamSupplier;
import io.activej.datastream.dsl.HasStreamInput;
import io.activej.datastream.dsl.HasStreamOutput;
import io.activej.datastream.processor.StreamConsumerTransformer;
import io.activej.datastream.processor.StreamFilter;
import io.activej.datastream.processor.StreamSupplierTransformer;
import java.util.function.Function;

public interface StreamTransformer<I, O>
extends HasStreamInput<I>,
HasStreamOutput<O>,
StreamSupplierTransformer<I, StreamSupplier<O>>,
StreamConsumerTransformer<O, StreamConsumer<I>> {
    public static <X> StreamTransformer<X, X> identity() {
        return StreamFilter.mapper(Function.identity());
    }

    @Override
    default public StreamConsumer<I> transform(StreamConsumer<O> consumer) {
        this.getOutput().streamTo(consumer);
        return this.getInput();
    }

    @Override
    default public StreamSupplier<O> transform(StreamSupplier<I> supplier) {
        supplier.streamTo(this.getInput());
        return this.getOutput();
    }
}

