/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream.stats;

import io.activej.common.Checks;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IntrusiveLinkedList<T>
implements Iterable<T> {
    private int size;
    @Nullable
    private Node<T> first;
    @Nullable
    private Node<T> last;

    IntrusiveLinkedList() {
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            @Nullable
            Node<T> node;
            {
                this.node = IntrusiveLinkedList.this.getFirstNode();
            }

            @Override
            public boolean hasNext() {
                return this.node != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.node.value;
                this.node = this.node.next;
                return result;
            }
        };
    }

    @Nullable
    public Node<T> getFirstNode() {
        return this.first;
    }

    @Nullable
    public Node<T> getLastNode() {
        return this.last;
    }

    @Nullable
    public T getFirstValue() {
        return this.first != null ? (T)this.first.value : null;
    }

    @Nullable
    public T getLastValue() {
        return this.last != null ? (T)this.last.value : null;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public void clear() {
        this.first = null;
        this.last = null;
    }

    public int size() {
        return this.size;
    }

    @Nullable
    public Node<T> removeFirstNode() {
        if (this.first == null) {
            return null;
        }
        Node<T> node = this.first;
        this.first = node.next;
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            assert (this.last == node);
            this.last = node.prev;
        }
        --this.size;
        node.prev = null;
        node.next = null;
        return node;
    }

    @Nullable
    public Node<T> removeLastNode() {
        if (this.last == null) {
            return null;
        }
        Node<T> node = this.last;
        this.last = node.prev;
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            assert (this.first == node);
            this.first = node.next;
        }
        --this.size;
        node.prev = null;
        node.next = null;
        return node;
    }

    @Nullable
    public T removeFirstValue() {
        Node<T> node = this.removeFirstNode();
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    @Nullable
    public T removeLastValue() {
        Node<T> node = this.removeLastNode();
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public Node<T> addFirstValue(T value) {
        Node<T> node = new Node<T>(value);
        this.addFirstNode(node);
        return node;
    }

    public Node<T> addLastValue(T value) {
        Node<T> node = new Node<T>(value);
        this.addLastNode(node);
        return node;
    }

    public void addFirstNode(Node<T> node) {
        Checks.checkArgument((node.prev == null && node.next == null ? 1 : 0) != 0, (Object)"Node should not have 'next' or 'prev' pointers");
        if (this.first != null) {
            assert (this.first.prev == null);
            this.first.prev = node;
            node.next = this.first;
        } else {
            assert (this.last == null);
            this.last = node;
        }
        this.first = node;
        ++this.size;
    }

    public void addLastNode(Node<T> node) {
        Checks.checkArgument((node.prev == null && node.next == null ? 1 : 0) != 0, (Object)"Node should not have 'next' or 'prev' pointers");
        if (this.last != null) {
            assert (this.last.next == null);
            this.last.next = node;
            node.prev = this.last;
        } else {
            assert (this.first == null);
            this.first = node;
        }
        this.last = node;
        ++this.size;
    }

    public void moveNodeToLast(Node<T> node) {
        if (node.next == null) {
            return;
        }
        this.removeNode(node);
        this.addLastNode(node);
    }

    public void moveNodeToFirst(Node<T> node) {
        if (node.prev == null) {
            return;
        }
        this.removeNode(node);
        this.addFirstNode(node);
    }

    public Node<T> addAfterNode(@Nullable Node<T> node, T value) {
        Checks.checkState((this.first != null && this.last != null ? 1 : 0) != 0, (Object)"Node is assumed to be in this list");
        if (node == null) {
            return this.addFirstValue(value);
        }
        if (node.next == null) {
            return this.addLastValue(value);
        }
        Node<T> newNode = new Node<T>(value);
        Node next = node.next;
        node.next = newNode;
        next.prev = newNode;
        newNode.prev = node;
        newNode.next = next;
        ++this.size;
        return newNode;
    }

    public Node<T> addBeforeNode(@Nullable Node<T> node, T value) {
        Checks.checkState((this.first != null && this.last != null ? 1 : 0) != 0);
        if (node == null) {
            return this.addLastValue(value);
        }
        if (node.prev == null) {
            return this.addFirstValue(value);
        }
        Node<T> newNode = new Node<T>(value);
        Node prev = node.prev;
        prev.next = newNode;
        node.prev = newNode;
        newNode.prev = prev;
        newNode.next = node;
        ++this.size;
        return newNode;
    }

    public void removeNode(Node<T> node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            assert (this.first == node);
            this.first = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            assert (this.last == node);
            this.last = node.prev;
        }
        node.prev = null;
        node.next = null;
        --this.size;
    }

    public static final class Node<T> {
        final T value;
        @Nullable
        Node<T> prev;
        @Nullable
        Node<T> next;

        @Nullable
        public Node<T> getPrev() {
            return this.prev;
        }

        @Nullable
        public Node<T> getNext() {
            return this.next;
        }

        public T getValue() {
            return this.value;
        }

        Node(T value) {
            this.value = value;
        }
    }
}

