/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream.stats;

import io.activej.common.Utils;
import io.activej.common.initializer.WithInitializer;
import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.dsl.ChannelConsumerTransformer;
import io.activej.csp.dsl.ChannelSupplierTransformer;
import io.activej.datastream.StreamConsumer;
import io.activej.datastream.StreamSupplier;
import io.activej.datastream.processor.StreamConsumerTransformer;
import io.activej.datastream.processor.StreamSupplierTransformer;
import io.activej.datastream.stats.IntrusiveLinkedList;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.promise.Promise;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class StreamRegistry<V>
implements Iterable<V>,
WithInitializer<StreamRegistry<V>> {
    private final IntrusiveLinkedList<Entry<V>> list = new IntrusiveLinkedList();

    public static <V> StreamRegistry<V> create() {
        return new StreamRegistry<V>();
    }

    public <T> RegisterTransformer<T> register(V value) {
        return new RegisterTransformer(value);
    }

    public <T> ChannelSupplier<T> register(ChannelSupplier<T> supplier, V value) {
        return supplier.withEndOfStream(this.subscribe(value));
    }

    public <T> ChannelConsumer<T> register(ChannelConsumer<T> consumer, V value) {
        return consumer.withAcknowledgement(this.subscribe(value));
    }

    public <T> StreamConsumer<T> register(StreamConsumer<T> consumer, V value) {
        return consumer.withAcknowledgement(this.subscribe(value));
    }

    public <T> StreamSupplier<T> register(StreamSupplier<T> supplier, V value) {
        return supplier.withEndOfStream(this.subscribe(value));
    }

    private UnaryOperator<Promise<Void>> subscribe(V value) {
        Entry entry = new Entry(value);
        IntrusiveLinkedList.Node node = this.list.addFirstValue(entry);
        return promise -> promise.whenComplete(() -> this.list.removeNode(node));
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        final Iterator<Entry<V>> iterator = this.list.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V next() {
                return ((Entry)iterator.next()).operation;
            }
        };
    }

    @JmxAttribute(name="")
    public String getString() {
        ArrayList entries = new ArrayList();
        this.list.forEach(entries::add);
        return Utils.toString(entries);
    }

    public final class RegisterTransformer<T>
    implements ChannelSupplierTransformer<T, ChannelSupplier<T>>,
    ChannelConsumerTransformer<T, ChannelConsumer<T>>,
    StreamSupplierTransformer<T, StreamSupplier<T>>,
    StreamConsumerTransformer<T, StreamConsumer<T>> {
        private final V value;

        private RegisterTransformer(V value) {
            this.value = value;
        }

        @Override
        public StreamConsumer<T> transform(StreamConsumer<T> consumer) {
            return StreamRegistry.this.register(consumer, this.value);
        }

        @Override
        public StreamSupplier<T> transform(StreamSupplier<T> supplier) {
            return StreamRegistry.this.register(supplier, this.value);
        }

        @Override
        public ChannelConsumer<T> transform(ChannelConsumer<T> consumer) {
            return StreamRegistry.this.register(consumer, this.value);
        }

        @Override
        public ChannelSupplier<T> transform(ChannelSupplier<T> supplier) {
            return StreamRegistry.this.register(supplier, this.value);
        }
    }

    private static class Entry<T> {
        private final long timestamp = System.currentTimeMillis();
        private final T operation;

        private Entry(T operation) {
            this.operation = operation;
        }

        public String toString() {
            return this.operation + " " + (System.currentTimeMillis() - this.timestamp);
        }
    }
}

