/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream.stats;

import io.activej.csp.ChannelConsumer;
import io.activej.csp.ChannelSupplier;
import io.activej.csp.dsl.ChannelConsumerTransformer;
import io.activej.csp.dsl.ChannelSupplierTransformer;
import io.activej.datastream.StreamConsumer;
import io.activej.datastream.StreamDataAcceptor;
import io.activej.datastream.StreamSupplier;
import io.activej.datastream.processor.StreamConsumerTransformer;
import io.activej.datastream.processor.StreamSupplierTransformer;
import io.activej.datastream.stats.StreamStatsBasic;
import io.activej.datastream.stats.StreamStatsDetailed;
import io.activej.datastream.stats.StreamStatsForwarder;
import io.activej.datastream.stats.StreamStatsSizeCounter;

public interface StreamStats<T>
extends StreamSupplierTransformer<T, StreamSupplier<T>>,
StreamConsumerTransformer<T, StreamConsumer<T>>,
ChannelSupplierTransformer<T, ChannelSupplier<T>>,
ChannelConsumerTransformer<T, ChannelConsumer<T>> {
    public StreamDataAcceptor<T> createDataAcceptor(StreamDataAcceptor<T> var1);

    public void onStarted();

    public void onResume();

    public void onSuspend();

    public void onEndOfStream();

    public void onError(Exception var1);

    @Override
    default public StreamConsumer<T> transform(StreamConsumer<T> consumer) {
        return (StreamConsumer)consumer.transformWith(StreamStatsForwarder.create(this));
    }

    @Override
    default public StreamSupplier<T> transform(StreamSupplier<T> supplier) {
        return (StreamSupplier)supplier.transformWith(StreamStatsForwarder.create(this));
    }

    @Override
    default public ChannelSupplier<T> transform(ChannelSupplier<T> supplier) {
        return supplier;
    }

    @Override
    default public ChannelConsumer<T> transform(ChannelConsumer<T> consumer) {
        return consumer;
    }

    public static <T> StreamStatsBasic<T> basic() {
        return new StreamStatsBasic();
    }

    public static <T> StreamStatsDetailed<T> detailed() {
        return new StreamStatsDetailed(null);
    }

    public static <T> StreamStatsDetailed<T> detailed(StreamStatsSizeCounter<T> sizeCounter) {
        return new StreamStatsDetailed(sizeCounter);
    }
}

