/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream.stats;

import io.activej.datastream.StreamDataAcceptor;
import io.activej.datastream.stats.StreamStats;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ExceptionStats;
import java.time.Duration;

public class StreamStatsBasic<T>
implements StreamStats<T> {
    public static final Duration DEFAULT_BASIC_SMOOTHING_WINDOW = Duration.ofMinutes(5L);
    private final EventStats started = EventStats.create((Duration)DEFAULT_BASIC_SMOOTHING_WINDOW);
    private final EventStats resume = EventStats.create((Duration)DEFAULT_BASIC_SMOOTHING_WINDOW);
    private final EventStats suspend = EventStats.create((Duration)DEFAULT_BASIC_SMOOTHING_WINDOW);
    private final EventStats endOfStream = EventStats.create((Duration)DEFAULT_BASIC_SMOOTHING_WINDOW);
    private final ExceptionStats error = ExceptionStats.create();

    public StreamStatsBasic<T> withBasicSmoothingWindow(Duration smoothingWindow) {
        this.started.setSmoothingWindow(smoothingWindow);
        this.resume.setSmoothingWindow(smoothingWindow);
        this.suspend.setSmoothingWindow(smoothingWindow);
        this.endOfStream.setSmoothingWindow(smoothingWindow);
        return this;
    }

    @Override
    public StreamDataAcceptor<T> createDataAcceptor(StreamDataAcceptor<T> actualDataAcceptor) {
        return actualDataAcceptor;
    }

    @Override
    public void onStarted() {
        this.started.recordEvent();
    }

    @Override
    public void onResume() {
        this.resume.recordEvent();
    }

    @Override
    public void onSuspend() {
        this.suspend.recordEvent();
    }

    @Override
    public void onEndOfStream() {
        this.endOfStream.recordEvent();
    }

    @Override
    public void onError(Exception e) {
        this.error.recordException((Throwable)e);
    }

    @JmxAttribute
    public EventStats getStarted() {
        return this.started;
    }

    @JmxAttribute
    public EventStats getResume() {
        return this.resume;
    }

    @JmxAttribute
    public EventStats getSuspend() {
        return this.suspend;
    }

    @JmxAttribute
    public EventStats getEndOfStream() {
        return this.endOfStream;
    }

    @JmxAttribute
    public ExceptionStats getError() {
        return this.error;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public int getActive() {
        return (int)(this.started.getTotalCount() - (this.endOfStream.getTotalCount() + (long)this.error.getTotal()));
    }
}

