/*
 * Decompiled with CFR 0.152.
 */
package io.activej.datastream.stats;

import io.activej.datastream.StreamDataAcceptor;
import io.activej.datastream.stats.StreamStatsBasic;
import io.activej.datastream.stats.StreamStatsSizeCounter;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.JmxStatsWithReset;
import io.activej.jmx.stats.StatsUtils;
import java.time.Duration;
import org.jetbrains.annotations.Nullable;

public final class StreamStatsDetailed<T>
extends StreamStatsBasic<T>
implements JmxStatsWithReset {
    @Nullable
    private final StreamStatsSizeCounter<Object> sizeCounter;
    private long count;
    private long totalSize;

    StreamStatsDetailed(@Nullable StreamStatsSizeCounter<?> sizeCounter) {
        this.sizeCounter = sizeCounter;
    }

    @Override
    public StreamStatsDetailed<T> withBasicSmoothingWindow(Duration smoothingWindow) {
        return (StreamStatsDetailed)super.withBasicSmoothingWindow(smoothingWindow);
    }

    @Override
    public StreamDataAcceptor<T> createDataAcceptor(StreamDataAcceptor<T> actualDataAcceptor) {
        return this.sizeCounter == null ? item -> {
            ++this.count;
            actualDataAcceptor.accept(item);
        } : item -> {
            ++this.count;
            int size = this.sizeCounter.size(item);
            this.totalSize += (long)size;
            actualDataAcceptor.accept(item);
        };
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getCount() {
        return this.count;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    @Nullable
    public Long getTotalSize() {
        return this.sizeCounter != null ? Long.valueOf(this.totalSize) : null;
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    @Nullable
    public Long getTotalSizeAvg() {
        return this.sizeCounter != null && this.getStarted().getTotalCount() != 0L ? Long.valueOf(this.totalSize / this.getStarted().getTotalCount()) : null;
    }

    public void resetStats() {
        this.totalSize = 0L;
        this.count = 0L;
        StatsUtils.resetStats((Object)this);
    }
}

