/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.callback;

import io.activej.async.callback.Callback;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.RunnableEx;
import io.activej.common.function.SupplierEx;

public interface AsyncComputation<T> {
    public void run(Callback<? super T> var1);

    public static AsyncComputation<Void> of(RunnableEx runnable) {
        return callback -> {
            try {
                runnable.run();
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)runnable);
                callback.accept(null, ex);
                return;
            }
            callback.accept(null, null);
        };
    }

    public static <T> AsyncComputation<T> of(SupplierEx<? extends T> runnable) {
        return callback -> {
            Object result;
            try {
                result = runnable.get();
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)runnable);
                callback.accept(null, ex);
                return;
            }
            callback.accept(result, null);
        };
    }

    public static <T> AsyncComputation<T> ofDeferred(SupplierEx<? extends AsyncComputation<? extends T>> computationSupplier) {
        return callback -> {
            AsyncComputation computation;
            try {
                computation = (AsyncComputation)computationSupplier.get();
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)computationSupplier);
                callback.accept(null, ex);
                return;
            }
            computation.run(callback);
        };
    }
}

