/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.util;

import io.activej.common.Utils;
import io.activej.common.function.BiConsumerEx;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LogUtils {
    public static String thisMethod() {
        try {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            return stackTraceElement.getMethodName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> BiConsumerEx<T, Exception> toLogger(Logger logger, Level callLevel, Supplier<String> callMsg, Level resultLevel, Function<T, String> resultMsg, @Nullable Level errorLevel, Function<Exception, String> errorMsg) {
        if (!logger.isErrorEnabled()) {
            return ($, e) -> {};
        }
        callLevel.log(logger, callMsg);
        return (result, e) -> {
            if (e == null) {
                resultLevel.log(logger, () -> (String)resultMsg.apply(result));
            } else if (errorLevel == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((String)errorMsg.apply((Exception)e), (Throwable)e);
                }
            } else {
                errorLevel.log(logger, () -> (String)errorMsg.apply((Exception)e));
            }
        };
    }

    public static <T> BiConsumerEx<T, Exception> toLogger(Logger logger, Level callLevel, Supplier<String> callMsg, Level resultLevel, Function<T, String> resultMsg) {
        return LogUtils.toLogger(logger, callLevel, callMsg, resultLevel, resultMsg, null, (Exception e) -> (String)callMsg.get());
    }

    public static <T> BiConsumerEx<T, Exception> toLogger(Logger logger, Level callLevel, Level resultLevel, Level errorLevel, String methodName, Object ... parameters) {
        return LogUtils.toLogger(logger, callLevel, () -> LogUtils.formatCall(methodName, parameters), resultLevel, (T result) -> LogUtils.formatResult(methodName, result, parameters), errorLevel, errorLevel == null ? e -> LogUtils.formatCall(methodName, parameters) : e -> LogUtils.formatResult(methodName, e, parameters));
    }

    public static <T> BiConsumerEx<T, Exception> toLogger(Logger logger, Level callLevel, Level resultLevel, String methodName, Object ... parameters) {
        return LogUtils.toLogger(logger, callLevel, resultLevel, null, methodName, parameters);
    }

    public static <T> BiConsumerEx<T, Exception> toLogger(Logger logger, Level level, String methodName, Object ... parameters) {
        return LogUtils.toLogger(logger, level, level, methodName, parameters);
    }

    public static <T> BiConsumerEx<T, Exception> toLogger(Logger logger, String methodName, Object ... parameters) {
        return LogUtils.toLogger(logger, Level.TRACE, Level.INFO, methodName, parameters);
    }

    private static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Collection) {
            return Utils.toString((Collection)((Collection)object));
        }
        return object.toString();
    }

    public static String formatCall(String methodName, Object ... parameters) {
        return methodName + (parameters.length != 0 ? " " + Arrays.stream(parameters).map(LogUtils::toString).collect(Collectors.joining(", ")) : "") + " \u2026";
    }

    public static String formatResult(String methodName, Object result, Object ... parameters) {
        return methodName + (parameters.length != 0 ? " " + Arrays.stream(parameters).map(LogUtils::toString).collect(Collectors.joining(", ")) : "") + " \u2192 " + LogUtils.toString(result);
    }

    public static enum Level {
        OFF(null){

            @Override
            protected boolean isEnabled(Logger logger) {
                return false;
            }
        }
        ,
        TRACE(Logger::trace){

            @Override
            protected boolean isEnabled(Logger logger) {
                return logger.isTraceEnabled();
            }
        }
        ,
        DEBUG(Logger::debug){

            @Override
            protected boolean isEnabled(Logger logger) {
                return logger.isDebugEnabled();
            }
        }
        ,
        INFO(Logger::info){

            @Override
            protected boolean isEnabled(Logger logger) {
                return logger.isInfoEnabled();
            }
        }
        ,
        WARN(Logger::warn){

            @Override
            protected boolean isEnabled(Logger logger) {
                return logger.isWarnEnabled();
            }
        }
        ,
        ERROR(Logger::error){

            @Override
            protected boolean isEnabled(Logger logger) {
                return logger.isErrorEnabled();
            }
        };

        private final BiConsumer<Logger, String> logConsumer;

        private Level(BiConsumer<Logger, String> logConsumer) {
            this.logConsumer = logConsumer;
        }

        protected abstract boolean isEnabled(Logger var1);

        public final void log(Logger logger, Supplier<String> messageSupplier) {
            if (this.isEnabled(logger)) {
                this.logConsumer.accept(logger, messageSupplier.get());
            }
        }

        public final void log(Logger logger, String message) {
            if (this.isEnabled(logger)) {
                this.logConsumer.accept(logger, message);
            }
        }
    }
}

