/*
 * Decompiled with CFR 0.152.
 */
package io.activej.eventloop;

import io.activej.async.callback.AsyncComputation;
import io.activej.async.callback.Callback;
import io.activej.async.exception.AsyncTimeoutException;
import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.exception.UncheckedException;
import io.activej.common.function.RunnableEx;
import io.activej.common.initializer.WithInitializer;
import io.activej.common.inspector.BaseInspector;
import io.activej.common.time.CurrentTimeProvider;
import io.activej.common.time.Stopwatch;
import io.activej.eventloop.NioChannelEventHandler;
import io.activej.eventloop.executor.EventloopExecutor;
import io.activej.eventloop.inspector.EventloopInspector;
import io.activej.eventloop.inspector.EventloopStats;
import io.activej.eventloop.jmx.EventloopJmxBeanWithStats;
import io.activej.eventloop.net.DatagramSocketSettings;
import io.activej.eventloop.net.ServerSocketSettings;
import io.activej.eventloop.schedule.ScheduledRunnable;
import io.activej.eventloop.schedule.Scheduler;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxOperation;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Eventloop
implements Runnable,
EventloopExecutor,
Scheduler,
WithInitializer<Eventloop>,
EventloopJmxBeanWithStats {
    public static final Logger logger = LoggerFactory.getLogger(Eventloop.class);
    private static final boolean CHECK = Checks.isEnabled(Eventloop.class);
    public static final Duration DEFAULT_SMOOTHING_WINDOW = Duration.ofMinutes(1L);
    public static final Duration DEFAULT_IDLE_INTERVAL = Duration.ofSeconds(1L);
    private final ArrayDeque<Runnable> localTasks = new ArrayDeque();
    private final ArrayList<Runnable> nextTasks = new ArrayList();
    private final ConcurrentLinkedQueue<Runnable> concurrentTasks = new ConcurrentLinkedQueue();
    private final PriorityQueue<ScheduledRunnable> scheduledTasks = new PriorityQueue();
    private final PriorityQueue<ScheduledRunnable> backgroundTasks = new PriorityQueue();
    private final AtomicInteger externalTasksCount = new AtomicInteger(0);
    private int loop;
    private int tick;
    private long timestamp;
    @NotNull
    private final CurrentTimeProvider timeProvider;
    @Nullable
    private Selector selector;
    @Nullable
    private SelectorProvider selectorProvider;
    @Nullable
    private Thread eventloopThread;
    private static final ThreadLocal<Eventloop> CURRENT_EVENTLOOP = new ThreadLocal();
    @Nullable
    private String threadName;
    private int threadPriority;
    @NotNull
    private FatalErrorHandler eventloopFatalErrorHandler = this::logFatalError;
    @Nullable
    private FatalErrorHandler threadFatalErrorHandler;
    private volatile boolean keepAlive;
    private volatile boolean breakEventloop;
    private Duration idleInterval = DEFAULT_IDLE_INTERVAL;
    private int lastSelectedKeys;
    private int cancelledKeys;
    private int lastExternalTasksCount;
    @Nullable
    private EventloopInspector inspector;
    private boolean monitoring = false;
    private static final String NO_CURRENT_EVENTLOOP_ERROR = "Trying to start async operations prior eventloop.run(), or from outside of eventloop.run() \nPossible solutions: 1) Eventloop.create().withCurrentThread() ... {your code block} ... eventloop.run() \n2) try_with_resources Eventloop.useCurrentThread() ... {your code block} \n3) refactor application so it starts async operations within eventloop.run(), \n   i.e. by implementing EventloopService::start() {your code block} and using ServiceGraphModule";

    private Eventloop(@NotNull CurrentTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.refreshTimestamp();
    }

    public static Eventloop create() {
        return Eventloop.create(CurrentTimeProvider.ofSystem());
    }

    public static Eventloop create(@NotNull CurrentTimeProvider currentTimeProvider) {
        return new Eventloop(currentTimeProvider);
    }

    @NotNull
    public Eventloop withThreadName(@Nullable String threadName) {
        this.threadName = threadName;
        return this;
    }

    @NotNull
    public Eventloop withThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
        return this;
    }

    @NotNull
    public Eventloop withInspector(@Nullable EventloopInspector inspector) {
        this.inspector = inspector;
        return this;
    }

    @NotNull
    public Eventloop withEventloopFatalErrorHandler(@NotNull FatalErrorHandler fatalErrorHandler) {
        this.eventloopFatalErrorHandler = fatalErrorHandler;
        return this;
    }

    @NotNull
    public Eventloop withThreadFatalErrorHandler(@Nullable FatalErrorHandler fatalErrorHandler) {
        this.threadFatalErrorHandler = fatalErrorHandler;
        return this;
    }

    @NotNull
    public Eventloop withSelectorProvider(@Nullable SelectorProvider selectorProvider) {
        this.selectorProvider = selectorProvider;
        return this;
    }

    @NotNull
    public Eventloop withIdleInterval(@NotNull Duration idleInterval) {
        this.idleInterval = idleInterval;
        return this;
    }

    @NotNull
    public Eventloop withCurrentThread() {
        CURRENT_EVENTLOOP.set(this);
        return this;
    }

    @Nullable
    public Selector getSelector() {
        return this.selector;
    }

    @NotNull
    public static Eventloop getCurrentEventloop() {
        Eventloop eventloop = CURRENT_EVENTLOOP.get();
        if (eventloop != null) {
            return eventloop;
        }
        throw new IllegalStateException(NO_CURRENT_EVENTLOOP_ERROR);
    }

    @Nullable
    public static Eventloop getCurrentEventloopOrNull() {
        return CURRENT_EVENTLOOP.get();
    }

    public static void initWithEventloop(@NotNull Eventloop anotherEventloop, @NotNull Runnable runnable) {
        Eventloop eventloop = CURRENT_EVENTLOOP.get();
        try {
            CURRENT_EVENTLOOP.set(anotherEventloop);
            runnable.run();
        }
        finally {
            CURRENT_EVENTLOOP.set(eventloop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T initWithEventloop(@NotNull Eventloop anotherEventloop, @NotNull Supplier<T> callable) {
        Eventloop eventloop = CURRENT_EVENTLOOP.get();
        try {
            CURRENT_EVENTLOOP.set(anotherEventloop);
            T t = callable.get();
            return t;
        }
        finally {
            CURRENT_EVENTLOOP.set(eventloop);
        }
    }

    private void openSelector() {
        if (this.selector == null) {
            try {
                this.selector = ((SelectorProvider)Utils.nonNullElseGet((Object)this.selectorProvider, SelectorProvider::provider)).openSelector();
            }
            catch (Exception e) {
                logger.error("Could not open selector", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void closeSelector() {
        if (this.selector != null) {
            try {
                this.selector.close();
                this.selector = null;
                this.cancelledKeys = 0;
            }
            catch (IOException e) {
                logger.error("Could not close selector", (Throwable)e);
            }
        }
    }

    @NotNull
    public Selector ensureSelector() {
        if (this.selector == null) {
            this.openSelector();
        }
        return this.selector;
    }

    public void closeChannel(@Nullable SelectableChannel channel, @Nullable SelectionKey key) {
        Checks.checkArgument((channel != null || key == null ? 1 : 0) != 0, (Object)"Either channel or key should be not null");
        if (channel == null || !channel.isOpen()) {
            return;
        }
        if (key != null && key.isValid()) {
            ++this.cancelledKeys;
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close channel {}", (Object)channel, (Object)e);
        }
    }

    public boolean inEventloopThread() {
        return this.eventloopThread == null || this.eventloopThread == Thread.currentThread();
    }

    public void keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        if (!keepAlive && this.selector != null) {
            this.selector.wakeup();
        }
    }

    public void breakEventloop() {
        this.breakEventloop = true;
        if (this.breakEventloop && this.selector != null) {
            this.selector.wakeup();
        }
    }

    private boolean isAlive() {
        if (this.breakEventloop) {
            return false;
        }
        this.lastExternalTasksCount = this.externalTasksCount.get();
        return !this.localTasks.isEmpty() || !this.scheduledTasks.isEmpty() || !this.concurrentTasks.isEmpty() || this.lastExternalTasksCount > 0 || this.keepAlive || this.selector != null && this.selector.isOpen() && this.selector.keys().size() - this.cancelledKeys > 0;
    }

    @Nullable
    public Thread getEventloopThread() {
        return this.eventloopThread;
    }

    @Override
    public void run() {
        this.eventloopThread = Thread.currentThread();
        if (this.threadName != null) {
            this.eventloopThread.setName(this.threadName);
        }
        if (this.threadPriority != 0) {
            this.eventloopThread.setPriority(this.threadPriority);
        }
        CURRENT_EVENTLOOP.set(this);
        if (this.threadFatalErrorHandler != null) {
            FatalErrorHandlers.setThreadFatalErrorHandler((FatalErrorHandler)this.threadFatalErrorHandler);
        }
        this.ensureSelector();
        assert (this.selector != null);
        this.breakEventloop = false;
        long timeAfterBusinessLogic = 0L;
        while (this.isAlive()) {
            try {
                long selectTimeout = this.getSelectTimeout();
                if (this.inspector != null) {
                    this.inspector.onUpdateSelectorSelectTimeout(selectTimeout);
                }
                this.lastSelectedKeys = selectTimeout <= 0L ? this.selector.selectNow() : this.selector.select(selectTimeout);
                this.cancelledKeys = 0;
            }
            catch (ClosedChannelException e) {
                logger.error("Selector is closed, exiting...", (Throwable)e);
                break;
            }
            catch (IOException e) {
                this.recordIoError(e, this.selector);
            }
            long timeAfterSelectorSelect = this.refreshTimestampAndGet();
            int keys = this.processSelectedKeys(this.selector.selectedKeys());
            int concurrentTasks = this.executeConcurrentTasks();
            int scheduledTasks = this.executeScheduledTasks();
            int backgroundTasks = this.executeBackgroundTasks();
            int localTasks = this.executeLocalTasks();
            if (this.inspector != null) {
                if (timeAfterBusinessLogic != 0L) {
                    long selectorSelectTime = timeAfterSelectorSelect - timeAfterBusinessLogic;
                    this.inspector.onUpdateSelectorSelectTime(selectorSelectTime);
                }
                timeAfterBusinessLogic = this.timestamp;
                boolean taskOrKeyPresent = keys + concurrentTasks + scheduledTasks + backgroundTasks + localTasks != 0;
                boolean externalTaskPresent = this.lastExternalTasksCount != 0;
                long businessLogicTime = timeAfterBusinessLogic - timeAfterSelectorSelect;
                this.inspector.onUpdateBusinessLogicTime(taskOrKeyPresent, externalTaskPresent, businessLogicTime);
            }
            ++this.loop;
            this.tick = 0;
        }
        logger.info("{} finished", (Object)this);
        this.eventloopThread = null;
        if (this.selector != null && this.selector.isOpen() && this.selector.keys().stream().anyMatch(SelectionKey::isValid)) {
            logger.warn("Selector is still open, because event loop {} has {} keys", (Object)this, this.selector.keys());
            return;
        }
        this.closeSelector();
        if (this.threadFatalErrorHandler != null) {
            FatalErrorHandlers.setThreadFatalErrorHandler(null);
        }
    }

    private long getSelectTimeout() {
        if (!this.concurrentTasks.isEmpty() || !this.localTasks.isEmpty()) {
            return 0L;
        }
        if (this.scheduledTasks.isEmpty() && this.backgroundTasks.isEmpty()) {
            return this.idleInterval.toMillis();
        }
        return Math.min(this.getTimeBeforeExecution(this.scheduledTasks), this.getTimeBeforeExecution(this.backgroundTasks));
    }

    private long getTimeBeforeExecution(PriorityQueue<ScheduledRunnable> taskQueue) {
        while (!taskQueue.isEmpty()) {
            ScheduledRunnable first = taskQueue.peek();
            if (first.isCancelled()) {
                taskQueue.poll();
                continue;
            }
            return first.getTimestamp() - this.currentTimeMillis();
        }
        return this.idleInterval.toMillis();
    }

    private int processSelectedKeys(@NotNull Set<SelectionKey> selectedKeys) {
        Iterator<Object> iterator;
        long startTimestamp = this.timestamp;
        Stopwatch sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        int invalidKeys = 0;
        int acceptKeys = 0;
        int connectKeys = 0;
        int readKeys = 0;
        int writeKeys = 0;
        Iterator<Object> iterator2 = iterator = this.lastSelectedKeys != 0 ? selectedKeys.iterator() : Collections.emptyIterator();
        while (iterator.hasNext()) {
            SelectionKey key = (SelectionKey)iterator.next();
            iterator.remove();
            if (!key.isValid()) {
                ++invalidKeys;
                continue;
            }
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            if (key.isAcceptable()) {
                this.onAccept(key);
                ++acceptKeys;
            } else if (key.isConnectable()) {
                this.onConnect(key);
                ++connectKeys;
            } else {
                if (key.isReadable()) {
                    this.onRead(key);
                    ++readKeys;
                }
                if (key.isValid()) {
                    if (key.isWritable()) {
                        this.onWrite(key);
                        ++writeKeys;
                    }
                } else {
                    ++invalidKeys;
                }
            }
            if (sw == null || this.inspector == null) continue;
            this.inspector.onUpdateSelectedKeyDuration(sw);
        }
        int keys = acceptKeys + connectKeys + readKeys + writeKeys + invalidKeys;
        if (keys != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateSelectedKeysStats(this.lastSelectedKeys, invalidKeys, acceptKeys, connectKeys, readKeys, writeKeys, loopTime);
            }
        }
        return keys;
    }

    private static void executeTask(@Async.Execute Runnable task) {
        task.run();
    }

    private int executeLocalTasks() {
        Runnable runnable;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        int localTasks = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((runnable = this.localTasks.poll()) != null) {
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            try {
                Eventloop.executeTask(runnable);
                ++this.tick;
                if (sw != null && this.inspector != null) {
                    this.inspector.onUpdateLocalTaskDuration(runnable, sw);
                }
            }
            catch (Throwable e) {
                this.onFatalError(e, runnable);
            }
            ++localTasks;
        }
        this.localTasks.addAll(this.nextTasks);
        this.nextTasks.clear();
        if (localTasks != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateLocalTasksStats(localTasks, loopTime);
            }
        }
        return localTasks;
    }

    private int executeConcurrentTasks() {
        Runnable runnable;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        int concurrentTasks = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((runnable = this.concurrentTasks.poll()) != null) {
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            try {
                Eventloop.executeTask(runnable);
                if (sw != null && this.inspector != null) {
                    this.inspector.onUpdateConcurrentTaskDuration(runnable, sw);
                }
            }
            catch (Throwable e) {
                this.onFatalError(e, runnable);
            }
            ++concurrentTasks;
        }
        if (concurrentTasks != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateConcurrentTasksStats(concurrentTasks, loopTime);
            }
        }
        return concurrentTasks;
    }

    private int executeScheduledTasks() {
        return this.executeScheduledTasks(this.scheduledTasks);
    }

    private int executeBackgroundTasks() {
        return this.executeScheduledTasks(this.backgroundTasks);
    }

    private int executeScheduledTasks(PriorityQueue<ScheduledRunnable> taskQueue) {
        ScheduledRunnable peeked;
        Stopwatch sw;
        long startTimestamp = this.timestamp;
        boolean background = taskQueue == this.backgroundTasks;
        int scheduledTasks = 0;
        Object object = sw = this.monitoring ? Stopwatch.createUnstarted() : null;
        while ((peeked = taskQueue.peek()) != null) {
            if (peeked.isCancelled()) {
                taskQueue.poll();
                continue;
            }
            if (peeked.getTimestamp() > this.currentTimeMillis()) break;
            taskQueue.poll();
            Runnable runnable = peeked.getRunnable();
            if (sw != null) {
                sw.reset();
                sw.start();
            }
            if (this.monitoring && this.inspector != null) {
                int overdue = (int)(System.currentTimeMillis() - peeked.getTimestamp());
                this.inspector.onScheduledTaskOverdue(overdue, background);
            }
            try {
                Eventloop.executeTask(runnable);
                ++this.tick;
                peeked.complete();
                if (sw != null && this.inspector != null) {
                    this.inspector.onUpdateScheduledTaskDuration(runnable, sw, background);
                }
            }
            catch (Throwable e) {
                this.onFatalError(e, runnable);
            }
            ++scheduledTasks;
        }
        if (scheduledTasks != 0) {
            long loopTime = this.refreshTimestampAndGet() - startTimestamp;
            if (this.inspector != null) {
                this.inspector.onUpdateScheduledTasksStats(scheduledTasks, loopTime, background);
            }
        }
        return scheduledTasks;
    }

    private void onAccept(SelectionKey key) {
        assert (this.inEventloopThread());
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        if (!serverSocketChannel.isOpen()) {
            key.cancel();
            return;
        }
        Consumer acceptCallback = (Consumer)key.attachment();
        while (true) {
            SocketChannel channel;
            try {
                channel = serverSocketChannel.accept();
                if (channel == null) break;
                channel.configureBlocking(false);
            }
            catch (ClosedChannelException e) {
                break;
            }
            catch (IOException e) {
                this.recordIoError(e, serverSocketChannel);
                break;
            }
            try {
                acceptCallback.accept(channel);
            }
            catch (Throwable e) {
                FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)e, (Object)acceptCallback);
                this.closeChannel(channel, null);
            }
        }
    }

    private void onConnect(SelectionKey key) {
        boolean connected;
        assert (this.inEventloopThread());
        Callback cb = (Callback)key.attachment();
        SocketChannel channel = (SocketChannel)key.channel();
        try {
            connected = channel.finishConnect();
        }
        catch (IOException e) {
            this.closeChannel(channel, key);
            cb.accept(null, e);
            return;
        }
        try {
            if (connected) {
                cb.accept(channel, null);
            } else {
                cb.accept(null, new IOException("Connection key was received but the channel was not connected - this is not possible without some bug in Java NIO"));
            }
        }
        catch (Throwable e) {
            FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)e, (Object)channel);
            this.closeChannel(channel, null);
        }
    }

    private void onRead(SelectionKey key) {
        assert (this.inEventloopThread());
        NioChannelEventHandler handler = (NioChannelEventHandler)key.attachment();
        try {
            handler.onReadReady();
        }
        catch (Throwable e) {
            FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)e, (Object)handler);
            this.closeChannel(key.channel(), null);
        }
    }

    private void onWrite(SelectionKey key) {
        assert (this.inEventloopThread());
        NioChannelEventHandler handler = (NioChannelEventHandler)key.attachment();
        try {
            handler.onWriteReady();
        }
        catch (Throwable e) {
            FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)e, (Object)handler);
            this.closeChannel(key.channel(), null);
        }
    }

    @NotNull
    public ServerSocketChannel listen(@Nullable InetSocketAddress address, @NotNull ServerSocketSettings serverSocketSettings, @NotNull Consumer<SocketChannel> acceptCallback) throws IOException {
        if (CHECK) {
            Checks.checkState((boolean)this.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        ServerSocketChannel serverSocketChannel = null;
        try {
            serverSocketChannel = ServerSocketChannel.open();
            serverSocketSettings.applySettings(serverSocketChannel);
            serverSocketChannel.configureBlocking(false);
            serverSocketChannel.bind(address, serverSocketSettings.getBacklog());
            serverSocketChannel.register(this.ensureSelector(), 16, acceptCallback);
            if (this.selector != null) {
                this.selector.wakeup();
            }
            return serverSocketChannel;
        }
        catch (IOException e) {
            if (serverSocketChannel != null) {
                this.closeChannel(serverSocketChannel, null);
            }
            throw e;
        }
    }

    @NotNull
    public static DatagramChannel createDatagramChannel(DatagramSocketSettings datagramSocketSettings, @Nullable InetSocketAddress bindAddress, @Nullable InetSocketAddress connectAddress) throws IOException {
        DatagramChannel datagramChannel = null;
        try {
            datagramChannel = DatagramChannel.open();
            datagramSocketSettings.applySettings(datagramChannel);
            datagramChannel.configureBlocking(false);
            datagramChannel.bind(bindAddress);
            if (connectAddress != null) {
                datagramChannel.connect(connectAddress);
            }
            return datagramChannel;
        }
        catch (IOException e) {
            if (datagramChannel != null) {
                try {
                    datagramChannel.close();
                }
                catch (Exception nested) {
                    logger.error("Failed closing datagram channel after I/O error", (Throwable)nested);
                    e.addSuppressed(nested);
                }
            }
            throw e;
        }
    }

    public void connect(SocketAddress address, @NotNull Callback<SocketChannel> cb) {
        this.connect(address, 0L, cb);
    }

    public void connect(SocketAddress address, @Nullable Duration timeout, @NotNull Callback<SocketChannel> cb) {
        this.connect(address, timeout == null ? 0L : timeout.toMillis(), cb);
    }

    public void connect(@NotNull SocketAddress address, long timeout, @NotNull Callback<SocketChannel> cb) {
        SocketChannel channel;
        if (CHECK) {
            Checks.checkState((boolean)this.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        try {
            channel = SocketChannel.open();
        }
        catch (IOException e2) {
            try {
                cb.accept(null, e2);
            }
            catch (Throwable e1) {
                FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)e1, cb);
            }
            return;
        }
        try {
            channel.configureBlocking(false);
            channel.connect(address);
            if (timeout == 0L) {
                channel.register(this.ensureSelector(), 8, cb);
            } else {
                ScheduledRunnable scheduledTimeout = this.delay(timeout, () -> {
                    this.closeChannel(channel, null);
                    cb.accept(null, new AsyncTimeoutException("Connection timed out"));
                });
                channel.register(this.ensureSelector(), 8, (result, e) -> {
                    scheduledTimeout.cancel();
                    cb.accept((SocketChannel)result, e);
                });
            }
            if (this.selector != null) {
                this.selector.wakeup();
            }
        }
        catch (IOException e3) {
            this.closeChannel(channel, null);
            try {
                cb.accept(null, e3);
            }
            catch (Throwable e1) {
                FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)e1, cb);
            }
        }
    }

    public long tick() {
        if (CHECK) {
            Checks.checkState((boolean)this.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        return (long)this.loop << 32 | (long)this.tick;
    }

    public void post(@NotNull @Async.Schedule Runnable runnable) {
        if (CHECK) {
            Checks.checkState((boolean)this.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        this.localTasks.addFirst(runnable);
    }

    public void postLast(@NotNull @Async.Schedule Runnable runnable) {
        if (CHECK) {
            Checks.checkState((boolean)this.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        this.localTasks.addLast(runnable);
    }

    public void postNext(@NotNull @Async.Schedule Runnable runnable) {
        if (CHECK) {
            Checks.checkState((boolean)this.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        this.nextTasks.add(runnable);
    }

    @Override
    public void execute(@NotNull @Async.Schedule Runnable runnable) {
        this.concurrentTasks.offer(runnable);
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    @Override
    @NotNull
    public ScheduledRunnable schedule(long timestamp, @NotNull @Async.Schedule Runnable runnable) {
        if (CHECK) {
            Checks.checkState((boolean)this.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        return this.addScheduledTask(timestamp, runnable, false);
    }

    @Override
    @NotNull
    public ScheduledRunnable scheduleBackground(long timestamp, @NotNull @Async.Schedule Runnable runnable) {
        if (CHECK) {
            Checks.checkState((boolean)this.inEventloopThread(), (Object)"Not in eventloop thread");
        }
        return this.addScheduledTask(timestamp, runnable, true);
    }

    @NotNull
    private ScheduledRunnable addScheduledTask(long timestamp, Runnable runnable, boolean background) {
        ScheduledRunnable scheduledTask = ScheduledRunnable.create(timestamp, runnable);
        PriorityQueue<ScheduledRunnable> taskQueue = background ? this.backgroundTasks : this.scheduledTasks;
        taskQueue.offer(scheduledTask);
        return scheduledTask;
    }

    public void startExternalTask() {
        this.externalTasksCount.incrementAndGet();
    }

    public void completeExternalTask() {
        this.externalTasksCount.decrementAndGet();
    }

    public long refreshTimestampAndGet() {
        this.refreshTimestamp();
        return this.timestamp;
    }

    private void refreshTimestamp() {
        this.timestamp = this.timeProvider.currentTimeMillis();
    }

    public long currentTimeMillis() {
        return this.timestamp;
    }

    @Override
    @NotNull
    public Eventloop getEventloop() {
        return this;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> submit(@NotNull RunnableEx computation) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.execute(() -> {
            try {
                computation.run();
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)ex, (Object)computation);
                future.completeExceptionally(ex);
                return;
            }
            future.complete(null);
        });
        return future;
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> submit(AsyncComputation<? extends T> computation) {
        CompletableFuture future = new CompletableFuture();
        this.execute(() -> {
            try {
                computation.run((result, e) -> {
                    if (e == null) {
                        future.complete(result);
                    } else {
                        future.completeExceptionally(e);
                    }
                });
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)ex, (Object)computation);
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    @JmxOperation(description="enable monitoring [ when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled) ]")
    public void startExtendedMonitoring() {
        this.monitoring = true;
    }

    @JmxOperation(description="disable monitoring [ when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled) ]")
    public void stopExtendedMonitoring() {
        this.monitoring = false;
    }

    @JmxAttribute(description="when monitoring is enabled more stats are collected, but it causes more overhead (for example, most of the durationStats are collected only when monitoring is enabled)")
    public boolean isExtendedMonitoring() {
        return this.monitoring;
    }

    private void recordIoError(@NotNull Exception e, @Nullable Object context) {
        logger.warn("IO Error in {}", context, (Object)e);
    }

    private void onFatalError(@NotNull Throwable e, @Nullable Runnable runnable) {
        if (runnable instanceof RunnableWithContext) {
            FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)e, (Object)((RunnableWithContext)runnable).getContext());
        } else {
            FatalErrorHandlers.handleError((FatalErrorHandler)this.eventloopFatalErrorHandler, (Throwable)e, (Object)runnable);
        }
    }

    public void logFatalError(@NotNull Throwable e, @Nullable Object context) {
        if (e instanceof UncheckedException) {
            e = e.getCause();
        }
        logger.error("Fatal error in {}", context, (Object)e);
        if (this.inspector != null) {
            if (this.inEventloopThread()) {
                this.inspector.onFatalError(e, context);
            } else {
                Throwable finalE = e;
                this.execute(() -> this.inspector.onFatalError(finalE, context));
            }
        }
    }

    @JmxAttribute
    public int getLoop() {
        return this.loop;
    }

    @JmxAttribute
    public long getTick() {
        return this.tick;
    }

    @NotNull
    public FatalErrorHandler getEventloopFatalErrorHandler() {
        return this.eventloopFatalErrorHandler;
    }

    @Nullable
    public FatalErrorHandler getThreadFatalErrorHandler() {
        return this.threadFatalErrorHandler;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    @JmxAttribute
    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @JmxAttribute(name="")
    @Nullable
    public EventloopStats getStats() {
        return (EventloopStats)BaseInspector.lookup((BaseInspector)this.inspector, EventloopStats.class);
    }

    @JmxAttribute
    public Duration getIdleInterval() {
        return this.idleInterval;
    }

    @JmxAttribute
    public void setIdleInterval(Duration idleInterval) {
        this.idleInterval = idleInterval;
    }

    public String toString() {
        int externalTasks;
        int selectorKeys;
        StringBuilder sb = new StringBuilder("Eventloop");
        if (this.threadName != null) {
            sb.append("(" + this.threadName + ")");
        }
        sb.append("{loop=" + this.loop);
        if (this.tick != 0) {
            sb.append(", tick=" + this.tick);
        }
        if (this.selector != null && this.selector.isOpen() && (selectorKeys = this.selector.keys().size() - this.cancelledKeys) != 0) {
            sb.append(", selectorKeys=" + selectorKeys);
        }
        if (!this.localTasks.isEmpty()) {
            sb.append(", localTasks=" + this.localTasks.size());
        }
        if (!this.scheduledTasks.isEmpty()) {
            sb.append(", scheduledTasks=" + this.scheduledTasks.size());
        }
        if (!this.backgroundTasks.isEmpty()) {
            sb.append(", backgroundTasks=" + this.backgroundTasks.size());
        }
        if (!this.concurrentTasks.isEmpty()) {
            sb.append(", concurrentTasks=" + this.concurrentTasks.size());
        }
        if ((externalTasks = this.externalTasksCount.get()) != 0) {
            sb.append(", externalTasks=" + externalTasks);
        }
        return sb.append('}').toString();
    }
}

