/*
 * Decompiled with CFR 0.152.
 */
package io.activej.eventloop.executor;

import io.activej.async.callback.AsyncComputation;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.RunnableEx;
import io.activej.common.initializer.WithInitializer;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.executor.EventloopExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public final class BlockingEventloopExecutor
implements EventloopExecutor,
WithInitializer<BlockingEventloopExecutor> {
    private final Eventloop eventloop;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final AtomicInteger tasks = new AtomicInteger();
    private final int limit;

    private BlockingEventloopExecutor(Eventloop eventloop, int limit) {
        this.eventloop = eventloop;
        this.limit = limit;
    }

    public static BlockingEventloopExecutor create(Eventloop eventloop, int limit) {
        return new BlockingEventloopExecutor(eventloop, limit);
    }

    public int getLimit() {
        return this.limit;
    }

    private void post(Runnable runnable) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.tasks.get() > this.limit) {
                this.notFull.await();
            }
            this.tasks.incrementAndGet();
            this.eventloop.execute(runnable);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void post(Runnable runnable, CompletableFuture<?> future) {
        try {
            this.post(runnable);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.completeExceptionally(e);
        }
    }

    private void complete() {
        this.lock.lock();
        try {
            this.tasks.decrementAndGet();
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void execute(@NotNull Runnable runnable) {
        try {
            this.post(() -> {
                try {
                    runnable.run();
                }
                finally {
                    this.complete();
                }
            });
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> submit(@NotNull RunnableEx computation) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.post(() -> {
            try {
                computation.run();
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)computation);
                future.completeExceptionally(ex);
                return;
            }
            finally {
                this.complete();
            }
            future.complete(null);
        }, future);
        return future;
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> submit(AsyncComputation<? extends T> computation) {
        CompletableFuture future = new CompletableFuture();
        this.post(() -> {
            try {
                computation.run((result, e) -> {
                    if (e == null) {
                        future.complete(result);
                    } else {
                        future.completeExceptionally(e);
                    }
                });
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)computation);
                future.completeExceptionally(ex);
            }
            finally {
                this.complete();
            }
        }, future);
        return future;
    }
}

