/*
 * Decompiled with CFR 0.152.
 */
package io.activej.eventloop.inspector;

import io.activej.common.initializer.WithInitializer;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.time.Stopwatch;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.inspector.EventloopInspector;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.JmxHistogram;
import io.activej.jmx.stats.JmxStats;
import io.activej.jmx.stats.JmxStatsWithReset;
import io.activej.jmx.stats.ValueStats;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventloopStats
extends AbstractInspector<EventloopInspector>
implements EventloopInspector,
WithInitializer<EventloopStats> {
    private final EventStats loops = EventStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW);
    private final ValueStats selectorSelectTimeout = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(new int[]{-256, -128, -64, -32, -16, -8, -4, -2, -1, 0, 1, 2, 4, 8, 16, 32}).withUnit("milliseconds");
    private final ValueStats selectorSelectTime = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO).withUnit("milliseconds");
    private final ValueStats businessLogicTime = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO).withUnit("milliseconds");
    private final Tasks tasks = new Tasks();
    private final Keys keys = new Keys();
    private final ExceptionStats fatalErrors = ExceptionStats.create();
    private final Map<Class<? extends Throwable>, ExceptionStats> fatalErrorsMap = new HashMap<Class<? extends Throwable>, ExceptionStats>();
    private final EventStats idleLoops = EventStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW);
    private final EventStats idleLoopsWaitingExternalTask = EventStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW);
    private final EventStats selectOverdues = EventStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW);

    private EventloopStats() {
    }

    public static EventloopStats create() {
        return new EventloopStats();
    }

    @Override
    public void onUpdateBusinessLogicTime(boolean taskOrKeyPresent, boolean externalTaskPresent, long businessLogicTime) {
        this.loops.recordEvent();
        if (taskOrKeyPresent) {
            this.businessLogicTime.recordValue((int)businessLogicTime);
        } else if (!externalTaskPresent) {
            this.idleLoops.recordEvent();
        } else {
            this.idleLoopsWaitingExternalTask.recordEvent();
        }
    }

    @Override
    public void onUpdateSelectorSelectTime(long selectorSelectTime) {
        this.selectorSelectTime.recordValue((int)selectorSelectTime);
    }

    @Override
    public void onUpdateSelectorSelectTimeout(long selectorSelectTimeout) {
        this.selectorSelectTimeout.recordValue((int)selectorSelectTimeout);
        if (selectorSelectTimeout < 0L) {
            this.selectOverdues.recordEvent();
        }
    }

    @Override
    public void onUpdateSelectedKeyDuration(@NotNull Stopwatch sw) {
        this.keys.oneKeyTime.recordValue((int)sw.elapsed(TimeUnit.MICROSECONDS));
    }

    @Override
    public void onUpdateSelectedKeysStats(int lastSelectedKeys, int invalidKeys, int acceptKeys, int connectKeys, int readKeys, int writeKeys, long loopTime) {
        this.keys.all.recordEvents(lastSelectedKeys);
        this.keys.invalid.recordEvents(invalidKeys);
        this.keys.acceptPerLoop.recordValue(acceptKeys);
        this.keys.connectPerLoop.recordValue(connectKeys);
        this.keys.readPerLoop.recordValue(readKeys);
        this.keys.writePerLoop.recordValue(writeKeys);
        if (lastSelectedKeys != 0) {
            this.keys.loopTime.recordValue((int)loopTime);
        }
    }

    private void updateTaskDuration(ValueStats counter, DurationRunnable longestCounter, Runnable runnable, @Nullable Stopwatch sw) {
        if (sw != null) {
            int elapsed = (int)sw.elapsed(TimeUnit.MICROSECONDS);
            counter.recordValue(elapsed);
            if ((long)elapsed > longestCounter.getDuration()) {
                longestCounter.update(runnable, elapsed);
            }
        }
    }

    @Override
    public void onUpdateLocalTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw) {
        this.updateTaskDuration(this.tasks.local.oneTaskTime, this.tasks.local.longestTask, runnable, sw);
    }

    @Override
    public void onUpdateLocalTasksStats(int localTasks, long loopTime) {
        if (localTasks != 0) {
            this.tasks.local.loopTime.recordValue((int)loopTime);
        }
        this.tasks.local.tasksPerLoop.recordValue(localTasks);
    }

    @Override
    public void onUpdateConcurrentTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw) {
        this.updateTaskDuration(this.tasks.concurrent.oneTaskTime, this.tasks.concurrent.longestTask, runnable, sw);
    }

    @Override
    public void onUpdateConcurrentTasksStats(int newConcurrentTasks, long loopTime) {
        if (newConcurrentTasks != 0) {
            this.tasks.concurrent.loopTime.recordValue((int)loopTime);
        }
        this.tasks.concurrent.tasksPerLoop.recordValue(newConcurrentTasks);
    }

    @Override
    public void onUpdateScheduledTaskDuration(@NotNull Runnable runnable, @Nullable Stopwatch sw, boolean background) {
        if (background) {
            this.updateTaskDuration(this.tasks.background.getOneTaskTime(), this.tasks.background.getLongestTask(), runnable, sw);
        } else {
            this.updateTaskDuration(this.tasks.scheduled.getOneTaskTime(), this.tasks.scheduled.getLongestTask(), runnable, sw);
        }
    }

    @Override
    public void onUpdateScheduledTasksStats(int scheduledTasks, long loopTime, boolean background) {
        if (background) {
            if (scheduledTasks != 0) {
                this.tasks.background.getLoopTime().recordValue((int)loopTime);
            }
            this.tasks.background.getTasksPerLoop().recordValue(scheduledTasks);
        } else {
            if (scheduledTasks != 0) {
                this.tasks.scheduled.getLoopTime().recordValue((int)loopTime);
            }
            this.tasks.scheduled.getTasksPerLoop().recordValue(scheduledTasks);
        }
    }

    @Override
    public void onFatalError(@NotNull Throwable e, Object context) {
        this.fatalErrors.recordException(e, context);
        Class<?> type = e.getClass();
        ExceptionStats stats = this.fatalErrorsMap.computeIfAbsent(type, k -> ExceptionStats.create());
        stats.recordException(e, context);
    }

    @Override
    public void onScheduledTaskOverdue(int overdue, boolean background) {
        if (background) {
            this.tasks.background.overdues.recordValue(overdue);
        } else {
            this.tasks.scheduled.overdues.recordValue(overdue);
        }
    }

    @JmxAttribute
    public EventStats getLoops() {
        return this.loops;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getSelectorSelectTime() {
        return this.selectorSelectTime;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getSelectorSelectTimeout() {
        return this.selectorSelectTimeout;
    }

    @JmxAttribute(extraSubAttributes={"histogram"})
    public ValueStats getBusinessLogicTime() {
        return this.businessLogicTime;
    }

    @JmxAttribute
    public Tasks getTasks() {
        return this.tasks;
    }

    @JmxAttribute
    public Keys getKeys() {
        return this.keys;
    }

    @JmxAttribute
    public ExceptionStats getFatalErrors() {
        return this.fatalErrors;
    }

    @JmxAttribute
    public Map<Class<? extends Throwable>, ExceptionStats> getFatalErrorsMap() {
        return this.fatalErrorsMap;
    }

    @JmxAttribute
    public EventStats getIdleLoops() {
        return this.idleLoops;
    }

    @JmxAttribute
    public EventStats getIdleLoopsWaitingExternalTask() {
        return this.idleLoopsWaitingExternalTask;
    }

    @JmxAttribute
    public EventStats getSelectOverdues() {
        return this.selectOverdues;
    }

    public static final class Tasks {
        private final TaskStats local = new TaskStats();
        private final TaskStats concurrent = new TaskStats();
        private final ScheduledTaskStats scheduled = new ScheduledTaskStats();
        private final ScheduledTaskStats background = new ScheduledTaskStats();

        Tasks() {
        }

        @JmxAttribute
        public TaskStats getLocal() {
            return this.local;
        }

        @JmxAttribute
        public TaskStats getConcurrent() {
            return this.concurrent;
        }

        @JmxAttribute
        public ScheduledTaskStats getScheduled() {
            return this.scheduled;
        }

        @JmxAttribute
        public ScheduledTaskStats getBackground() {
            return this.background;
        }
    }

    public static final class Keys {
        private final EventStats all = EventStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withRateUnit("keys");
        private final EventStats invalid = EventStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withRateUnit("keys");
        private final ValueStats acceptPerLoop = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO);
        private final ValueStats connectPerLoop = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO);
        private final ValueStats readPerLoop = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO);
        private final ValueStats writePerLoop = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO);
        private final ValueStats loopTime = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO).withUnit("milliseconds");
        private final ValueStats oneKeyTime = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO).withUnit("microseconds");

        @JmxAttribute
        public EventStats getAll() {
            return this.all;
        }

        @JmxAttribute
        public EventStats getInvalid() {
            return this.invalid;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getAcceptPerLoop() {
            return this.acceptPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getConnectPerLoop() {
            return this.connectPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getReadPerLoop() {
            return this.readPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getWritePerLoop() {
            return this.writePerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getLoopTime() {
            return this.loopTime;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getOneKeyTime() {
            return this.oneKeyTime;
        }
    }

    public static final class DurationRunnable
    implements JmxStats<DurationRunnable>,
    JmxStatsWithReset {
        private long duration;
        @Nullable
        private Runnable runnable;

        public void resetStats() {
            this.duration = 0L;
            this.runnable = null;
        }

        void update(Runnable runnable, long duration) {
            this.duration = duration;
            this.runnable = runnable;
        }

        @JmxAttribute(name="duration(\u03bcs)")
        public long getDuration() {
            return this.duration;
        }

        @JmxAttribute
        public String getClassName() {
            return this.runnable == null ? "" : this.runnable.getClass().getName();
        }

        public void add(DurationRunnable another) {
            if (another.duration > this.duration) {
                this.duration = another.duration;
                this.runnable = another.runnable;
            }
        }
    }

    public static class TaskStats {
        private final ValueStats tasksPerLoop = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO);
        private final ValueStats loopTime = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO).withUnit("milliseconds");
        private final ValueStats oneTaskTime = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO).withUnit("microseconds");
        private final DurationRunnable longestTask = new DurationRunnable();

        TaskStats() {
        }

        @JmxAttribute(name="perLoop", extraSubAttributes={"histogram"})
        public ValueStats getTasksPerLoop() {
            return this.tasksPerLoop;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getLoopTime() {
            return this.loopTime;
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getOneTaskTime() {
            return this.oneTaskTime;
        }

        @JmxAttribute
        public DurationRunnable getLongestTask() {
            return this.longestTask;
        }

        @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
        public int getCount() {
            return (int)this.tasksPerLoop.getLastValue();
        }
    }

    public static final class ScheduledTaskStats
    extends TaskStats {
        private final ValueStats overdues = ValueStats.create((Duration)Eventloop.DEFAULT_SMOOTHING_WINDOW).withHistogram(JmxHistogram.POWERS_OF_TWO).withRate().withUnit("milliseconds");

        ScheduledTaskStats() {
        }

        @JmxAttribute(extraSubAttributes={"histogram"})
        public ValueStats getOverdues() {
            return this.overdues;
        }
    }

    private static final class StackTrace {
        private final StackTraceElement[] stackTraceElements;

        public StackTrace(StackTraceElement[] stackTraceElements) {
            this.stackTraceElements = stackTraceElements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StackTrace)) {
                return false;
            }
            StackTrace that = (StackTrace)o;
            return Arrays.equals(this.stackTraceElements, that.stackTraceElements);
        }

        public int hashCode() {
            return this.stackTraceElements != null ? Arrays.hashCode(this.stackTraceElements) : 0;
        }
    }
}

