/*
 * Decompiled with CFR 0.152.
 */
package io.activej.eventloop.jmx;

import io.activej.common.Checks;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.jmx.api.JmxBeanAdapterWithRefresh;
import io.activej.jmx.api.JmxRefreshable;
import io.activej.jmx.stats.ValueStats;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class EventloopJmxBeanAdapter
implements JmxBeanAdapterWithRefresh {
    private static final Duration DEFAULT_SMOOTHING_WINDOW = Duration.ofMinutes(1L);
    private final Map<Eventloop, List<JmxRefreshable>> eventloopToJmxRefreshables = new ConcurrentHashMap<Eventloop, List<JmxRefreshable>>();
    private final Set<JmxRefreshable> allRefreshables = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<Object, Eventloop> beanToEventloop = new IdentityHashMap<Object, Eventloop>();
    private volatile Duration refreshPeriod;
    private int maxRefreshesPerCycle;

    public synchronized void execute(Object bean, Runnable command) {
        Eventloop eventloop = this.beanToEventloop.get(bean);
        Checks.checkNotNull((Object)eventloop, () -> "Unregistered bean " + bean);
        eventloop.execute(RunnableWithContext.wrapContext(bean, command));
    }

    public void setRefreshParameters(@NotNull Duration refreshPeriod, int maxRefreshesPerCycle) {
        Checks.checkArgument((refreshPeriod.toMillis() > 0L ? 1 : 0) != 0);
        Checks.checkArgument((maxRefreshesPerCycle > 0 ? 1 : 0) != 0);
        this.refreshPeriod = refreshPeriod;
        this.maxRefreshesPerCycle = maxRefreshesPerCycle;
        for (Map.Entry<Eventloop, List<JmxRefreshable>> entry : this.eventloopToJmxRefreshables.entrySet()) {
            entry.getKey().execute(() -> ((ValueStats)((List)entry.getValue()).get(0)).resetStats());
        }
    }

    public synchronized void registerRefreshableBean(Object bean, List<JmxRefreshable> beanRefreshables) {
        Checks.checkNotNull((Object)this.refreshPeriod, (Object)"Not initialized");
        Eventloop eventloop = this.ensureEventloop(bean);
        if (!this.eventloopToJmxRefreshables.containsKey(eventloop)) {
            Duration smoothingWindows = eventloop.getSmoothingWindow();
            if (smoothingWindows == null) {
                smoothingWindows = DEFAULT_SMOOTHING_WINDOW;
            }
            ValueStats refreshStats = ValueStats.create((Duration)smoothingWindows).withRate().withUnit("ns");
            ArrayList<ValueStats> list = new ArrayList<ValueStats>();
            list.add(refreshStats);
            this.eventloopToJmxRefreshables.put(eventloop, list);
            eventloop.execute(() -> this.refresh(eventloop, list, 0, refreshStats));
        }
        HashSet<JmxRefreshable> beanRefreshablesFiltered = new HashSet<JmxRefreshable>();
        for (JmxRefreshable refreshable : beanRefreshables) {
            if (!this.allRefreshables.add(refreshable)) continue;
            beanRefreshablesFiltered.add(refreshable);
        }
        eventloop.submit(() -> {
            List<JmxRefreshable> refreshables = this.eventloopToJmxRefreshables.get(eventloop);
            refreshables.addAll(beanRefreshablesFiltered);
        });
    }

    private Eventloop ensureEventloop(Object bean) {
        Eventloop eventloop = this.beanToEventloop.get(bean);
        if (eventloop == null) {
            try {
                eventloop = (Eventloop)bean.getClass().getMethod("getEventloop", new Class[0]).invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Class annotated with @EventloopJmxBean should have a 'getEventloop()' method");
            }
            Checks.checkNotNull((Object)eventloop);
            this.beanToEventloop.put(bean, eventloop);
        }
        return eventloop;
    }

    public List<String> getRefreshStats() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.eventloopToJmxRefreshables.size() > 1) {
            int count = 0;
            ValueStats total = ValueStats.createAccumulator().withRate().withUnit("ms");
            for (List<JmxRefreshable> refreshables : this.eventloopToJmxRefreshables.values()) {
                total.add((ValueStats)refreshables.get(0));
                count += refreshables.size();
            }
            result.add(EventloopJmxBeanAdapter.getStatsString(count, total));
        }
        for (List<JmxRefreshable> refreshables : this.eventloopToJmxRefreshables.values()) {
            result.add(EventloopJmxBeanAdapter.getStatsString(refreshables.size(), (ValueStats)refreshables.get(0)));
        }
        return result;
    }

    private void refresh(@NotNull Eventloop eventloop, @NotNull List<JmxRefreshable> list, int startIndex, ValueStats refreshStats) {
        Checks.checkState((boolean)eventloop.inEventloopThread());
        long timestamp = eventloop.currentTimeMillis();
        int index = startIndex < list.size() ? startIndex : 0;
        int endIndex = Math.min(list.size(), index + this.maxRefreshesPerCycle);
        long currentNanos = System.nanoTime();
        while (index < endIndex) {
            list.get(index++).refresh(timestamp);
        }
        long refreshTimeNanos = System.nanoTime() - currentNanos;
        refreshStats.recordValue((double)refreshTimeNanos);
        long nextTimestamp = timestamp + this.computeEffectiveRefreshPeriod(list.size());
        eventloop.scheduleBackground(nextTimestamp, () -> this.refresh(eventloop, list, endIndex, refreshStats));
    }

    private long computeEffectiveRefreshPeriod(int totalCount) {
        return this.maxRefreshesPerCycle >= totalCount ? this.refreshPeriod.toMillis() : this.refreshPeriod.toMillis() * (long)this.maxRefreshesPerCycle / (long)totalCount;
    }

    private static String getStatsString(int numberOfRefreshables, ValueStats stats) {
        return "# of refreshables: " + numberOfRefreshables + "  " + stats;
    }
}

