/*
 * Decompiled with CFR 0.152.
 */
package io.activej.eventloop.net;

import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.initializer.WithInitializer;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import org.jetbrains.annotations.NotNull;

public final class DatagramSocketSettings
implements WithInitializer<DatagramSocketSettings> {
    private static final byte DEF_BOOL = -1;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private final int receiveBufferSize;
    private final byte reuseAddress;
    private final int sendBufferSize;
    private final byte broadcast;

    private DatagramSocketSettings(int receiveBufferSize, int sendBufferSize, byte reuseAddress, byte broadcast) {
        this.receiveBufferSize = receiveBufferSize;
        this.reuseAddress = reuseAddress;
        this.sendBufferSize = sendBufferSize;
        this.broadcast = broadcast;
    }

    public static DatagramSocketSettings create() {
        return new DatagramSocketSettings(0, 0, -1, -1);
    }

    public DatagramSocketSettings withReceiveBufferSize(@NotNull MemSize receiveBufferSize) {
        return new DatagramSocketSettings(receiveBufferSize.toInt(), this.sendBufferSize, this.reuseAddress, this.broadcast);
    }

    public DatagramSocketSettings withSendBufferSize(@NotNull MemSize sendBufferSize) {
        return new DatagramSocketSettings(this.receiveBufferSize, sendBufferSize.toInt(), this.reuseAddress, this.broadcast);
    }

    public DatagramSocketSettings withReuseAddress(boolean reuseAddress) {
        return new DatagramSocketSettings(this.receiveBufferSize, this.sendBufferSize, reuseAddress ? (byte)1 : 0, this.broadcast);
    }

    public DatagramSocketSettings withBroadcast(boolean broadcast) {
        return new DatagramSocketSettings(this.receiveBufferSize, this.sendBufferSize, this.reuseAddress, broadcast ? (byte)1 : 0);
    }

    public void applySettings(@NotNull DatagramChannel channel) throws IOException {
        if (this.receiveBufferSize != 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.receiveBufferSize);
        }
        if (this.sendBufferSize != 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.sendBufferSize);
        }
        if (this.reuseAddress != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)(this.reuseAddress != 0 ? 1 : 0));
        }
        if (this.broadcast != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)(this.broadcast != 0 ? 1 : 0));
        }
    }

    public boolean hasReceiveBufferSize() {
        return this.receiveBufferSize != 0;
    }

    @NotNull
    public MemSize getReceiveBufferSize() {
        return MemSize.of((long)this.getReceiveBufferSizeBytes());
    }

    public int getReceiveBufferSizeBytes() {
        Checks.checkState((boolean)this.hasReceiveBufferSize(), (Object)"No 'receive buffer size' setting is present");
        return this.receiveBufferSize;
    }

    public boolean hasReuseAddress() {
        return this.reuseAddress != -1;
    }

    public boolean getReuseAddress() {
        Checks.checkState((boolean)this.hasReuseAddress(), (Object)"No 'reuse address' setting is present");
        return this.reuseAddress != 0;
    }

    public boolean hasSendBufferSize() {
        return this.sendBufferSize != 0;
    }

    @NotNull
    public MemSize getSendBufferSize() {
        return MemSize.of((long)this.getSendBufferSizeBytes());
    }

    public int getSendBufferSizeBytes() {
        Checks.checkState((boolean)this.hasSendBufferSize(), (Object)"No 'send buffer size' setting is present");
        return this.sendBufferSize;
    }

    public boolean hasBroadcast() {
        return this.broadcast != -1;
    }

    public boolean getBroadcast() {
        Checks.checkState((boolean)this.hasBroadcast(), (Object)"No 'broadcast' setting is present");
        return this.broadcast != 0;
    }
}

