/*
 * Decompiled with CFR 0.152.
 */
package io.activej.eventloop.net;

import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.initializer.WithInitializer;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SocketSettings
implements WithInitializer<SocketSettings> {
    private static final byte DEF_BOOL = -1;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private final byte keepAlive;
    private final byte reuseAddress;
    private final byte tcpNoDelay;
    private final int sendBufferSize;
    private final int receiveBufferSize;
    private final int implReadTimeout;
    private final int implWriteTimeout;
    private final int implReadBufferSize;
    private final int lingerTimeout;

    private SocketSettings(int sendBufferSize, int receiveBufferSize, byte keepAlive, byte reuseAddress, byte tcpNoDelay, int implReadTimeout, int implWriteTimeout, int implReadBufferSize, int lingerTimeout) {
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
        this.keepAlive = keepAlive;
        this.reuseAddress = reuseAddress;
        this.tcpNoDelay = tcpNoDelay;
        this.implReadTimeout = implReadTimeout;
        this.implWriteTimeout = implWriteTimeout;
        this.implReadBufferSize = implReadBufferSize;
        this.lingerTimeout = lingerTimeout;
    }

    public static SocketSettings create() {
        return new SocketSettings(0, 0, -1, -1, -1, 0, 0, 0, -1);
    }

    public static SocketSettings createDefault() {
        return new SocketSettings(0, 0, -1, -1, 1, 0, 0, 0, -1);
    }

    public SocketSettings withSendBufferSize(@NotNull MemSize sendBufferSize) {
        return new SocketSettings(sendBufferSize.toInt(), this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadBufferSize, this.lingerTimeout);
    }

    public SocketSettings withReceiveBufferSize(@NotNull MemSize receiveBufferSize) {
        return new SocketSettings(this.sendBufferSize, receiveBufferSize.toInt(), this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadBufferSize, this.lingerTimeout);
    }

    public SocketSettings withKeepAlive(boolean keepAlive) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, keepAlive ? (byte)1 : 0, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadBufferSize, this.lingerTimeout);
    }

    public SocketSettings withReuseAddress(boolean reuseAddress) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, reuseAddress ? (byte)1 : 0, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadBufferSize, this.lingerTimeout);
    }

    public SocketSettings withTcpNoDelay(boolean tcpNoDelay) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, tcpNoDelay ? (byte)1 : 0, this.implReadTimeout, this.implWriteTimeout, this.implReadBufferSize, this.lingerTimeout);
    }

    public SocketSettings withImplReadTimeout(@NotNull Duration implReadTimeout) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, (int)implReadTimeout.toMillis(), this.implWriteTimeout, this.implReadBufferSize, this.lingerTimeout);
    }

    public SocketSettings withImplWriteTimeout(@NotNull Duration implWriteTimeout) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, (int)implWriteTimeout.toMillis(), this.implReadBufferSize, this.lingerTimeout);
    }

    public SocketSettings withImplReadBufferSize(@NotNull MemSize implReadBufferSize) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, implReadBufferSize.toInt(), this.lingerTimeout);
    }

    public SocketSettings withLingerTimeout(Duration lingerTimeout) {
        return new SocketSettings(this.sendBufferSize, this.receiveBufferSize, this.keepAlive, this.reuseAddress, this.tcpNoDelay, this.implReadTimeout, this.implWriteTimeout, this.implReadBufferSize, (int)(lingerTimeout.toMillis() / 1000L));
    }

    public void applySettings(@NotNull SocketChannel channel) throws IOException {
        if (this.sendBufferSize != 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.sendBufferSize);
        }
        if (this.receiveBufferSize != 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.receiveBufferSize);
        }
        if (this.keepAlive != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)(this.keepAlive != 0 ? 1 : 0));
        }
        if (this.reuseAddress != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)(this.reuseAddress != 0 ? 1 : 0));
        }
        if (this.tcpNoDelay != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)(this.tcpNoDelay != 0 ? 1 : 0));
        }
        if (this.lingerTimeout != -1) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)this.lingerTimeout);
        }
    }

    public boolean hasSendBufferSize() {
        return this.sendBufferSize != 0;
    }

    @NotNull
    public MemSize getSendBufferSize() {
        return MemSize.of((long)this.getSendBufferSizeBytes());
    }

    public int getSendBufferSizeBytes() {
        Checks.checkState((boolean)this.hasSendBufferSize(), (Object)"No 'send buffer size' setting is present");
        return this.sendBufferSize;
    }

    public boolean hasReceiveBufferSize() {
        return this.receiveBufferSize != 0;
    }

    @NotNull
    public MemSize getReceiveBufferSize() {
        return MemSize.of((long)this.getReceiveBufferSizeBytes());
    }

    public int getReceiveBufferSizeBytes() {
        Checks.checkState((boolean)this.hasReceiveBufferSize(), (Object)"No 'receive buffer size' setting is present");
        return this.receiveBufferSize;
    }

    public boolean hasKeepAlive() {
        return this.keepAlive != -1;
    }

    public boolean getKeepAlive() {
        Checks.checkState((boolean)this.hasKeepAlive(), (Object)"No 'keep alive' setting is present");
        return this.keepAlive != 0;
    }

    public boolean hasReuseAddress() {
        return this.reuseAddress != -1;
    }

    public boolean getReuseAddress() {
        Checks.checkState((boolean)this.hasReuseAddress(), (Object)"No 'reuse address' setting is present");
        return this.reuseAddress != 0;
    }

    public boolean hasTcpNoDelay() {
        return this.tcpNoDelay != -1;
    }

    public boolean getTcpNoDelay() {
        Checks.checkState((boolean)this.hasTcpNoDelay(), (Object)"No 'TCP no delay' setting is present");
        return this.tcpNoDelay != 0;
    }

    public boolean hasImplReadTimeout() {
        return this.implReadTimeout != 0;
    }

    @NotNull
    public Duration getImplReadTimeout() {
        return Duration.ofMillis(this.getImplReadTimeoutMillis());
    }

    public long getImplReadTimeoutMillis() {
        Checks.checkState((boolean)this.hasImplReadTimeout(), (Object)"No 'implicit read timeout' setting is present");
        return this.implReadTimeout;
    }

    public boolean hasImplWriteTimeout() {
        return this.implWriteTimeout != 0;
    }

    @NotNull
    public Duration getImplWriteTimeout() {
        return Duration.ofMillis(this.getImplWriteTimeoutMillis());
    }

    public long getImplWriteTimeoutMillis() {
        Checks.checkState((boolean)this.hasImplWriteTimeout(), (Object)"No 'implicit write timeout' setting is present");
        return this.implWriteTimeout;
    }

    public boolean hasReadBufferSize() {
        return this.implReadBufferSize != 0;
    }

    @NotNull
    public MemSize getImplReadBufferSize() {
        return MemSize.of((long)this.getImplReadBufferSizeBytes());
    }

    public int getImplReadBufferSizeBytes() {
        Checks.checkState((boolean)this.hasReadBufferSize(), (Object)"No 'read buffer size' setting is present");
        return this.implReadBufferSize;
    }

    public boolean hasLingerTimeout() {
        return this.lingerTimeout != -1;
    }

    @Nullable
    public Duration getLingerTimeout() {
        return this.lingerTimeout == -1 ? null : Duration.ofSeconds(this.lingerTimeout);
    }

    public int getLingerTimeoutSeconds() {
        Checks.checkState((boolean)this.hasLingerTimeout(), (Object)"No 'linger timeout' setting is present");
        return this.implReadBufferSize;
    }
}

