/*
 * Decompiled with CFR 0.152.
 */
package io.activej.eventloop.util;

import io.activej.common.ApplicationSettings;

public interface RunnableWithContext
extends Runnable {
    public static final boolean WRAP_CONTEXT = ApplicationSettings.getBoolean(RunnableWithContext.class, (String)"wrapContext", (boolean)false);

    public Object getContext();

    public static RunnableWithContext of(final Object context, final Runnable runnable) {
        return new RunnableWithContext(){

            @Override
            public Object getContext() {
                return context;
            }

            @Override
            public void run() {
                runnable.run();
            }

            public String toString() {
                return "RunnableWithContext{runnable=" + runnable + ", context=" + context + '}';
            }
        };
    }

    public static Runnable wrapContext(Object context, Runnable runnable) {
        return WRAP_CONTEXT ? RunnableWithContext.of(context, runnable) : runnable;
    }
}

