/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject;

import io.activej.inject.InstanceInjector;
import io.activej.inject.InstanceProvider;
import io.activej.inject.Key;
import io.activej.inject.ResourceLocator;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.binding.BindingGenerators;
import io.activej.inject.binding.BindingToKey;
import io.activej.inject.binding.BindingTransformer;
import io.activej.inject.binding.BindingTransformers;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.DIException;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.binding.Multibinders;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.impl.CompiledBinding;
import io.activej.inject.impl.CompiledBindingLocator;
import io.activej.inject.impl.Preprocessor;
import io.activej.inject.module.Module;
import io.activej.inject.module.Modules;
import io.activej.inject.util.Trie;
import io.activej.inject.util.Utils;
import io.activej.types.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Injector
implements ResourceLocator {
    @Nullable
    final Injector parent;
    final Trie<Scope, ScopeLocalData> scopeDataTree;
    final Map<Key<?>, Integer> localSlotMapping;
    final Map<Key<?>, CompiledBinding<?>> localCompiledBindings;
    final AtomicReferenceArray[] scopeCaches;
    private static Supplier<UnaryOperator<CompiledBinding<?>>> bytecodePostprocessorFactory = UnaryOperator::identity;

    public static void useSpecializer() {
        try {
            Class<?> aClass = Class.forName("io.activej.specializer.Utils$InjectorSpecializer");
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object specializerInstance = constructor.newInstance(new Object[0]);
            UnaryOperator specializer = (UnaryOperator)specializerInstance;
            bytecodePostprocessorFactory = () -> specializer;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Cannot access ActiveJ Specializer", e);
        }
    }

    private Injector(@Nullable Injector parent, Trie<Scope, ScopeLocalData> scopeDataTree) {
        this.parent = parent;
        this.scopeDataTree = scopeDataTree;
        ScopeLocalData data = scopeDataTree.get();
        this.localSlotMapping = data.slotMapping;
        this.localCompiledBindings = data.compiledBindings;
        AtomicReferenceArray[] scopeCaches = parent == null ? new AtomicReferenceArray[1] : Arrays.copyOf(parent.scopeCaches, parent.scopeCaches.length + 1);
        AtomicReferenceArray<Injector> localCache = new AtomicReferenceArray<Injector>(data.slots);
        localCache.set(0, this);
        scopeCaches[scopeCaches.length - 1] = localCache;
        this.scopeCaches = scopeCaches;
    }

    public static Injector of(Module ... modules) {
        return Injector.compile(null, Modules.combine(modules));
    }

    public static Injector of(@Nullable Injector parent, Module ... modules) {
        return Injector.compile(parent, Modules.combine(modules));
    }

    public static Injector of(@NotNull Trie<Scope, Map<Key<?>, Binding<?>>> bindings) {
        return Injector.compile(null, Scope.UNSCOPED, bindings.map(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singleton((Binding)entry.getValue())))), Multibinders.errorOnDuplicate(), BindingTransformers.identity(), BindingGenerators.refusing());
    }

    public static Injector compile(@Nullable Injector parent, Module module) {
        return Injector.compile(parent, Scope.UNSCOPED, module.getBindings(), Multibinders.combinedMultibinder(module.getMultibinders()), BindingTransformers.combinedTransformer(module.getBindingTransformers()), BindingGenerators.combinedGenerator(module.getBindingGenerators()));
    }

    public static Injector compile(@Nullable Injector parent, Scope[] scope, @NotNull Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindingsMultimap, @NotNull Multibinder<?> multibinder, @NotNull BindingTransformer<?> transformer, @NotNull BindingGenerator<?> generator) {
        Trie<Scope, Map<Key<?>, Binding<?>>> bindings = Preprocessor.reduce(bindingsMultimap, multibinder, transformer, generator);
        HashSet known = new HashSet();
        known.add(Key.of(Injector.class));
        if (parent != null) {
            known.addAll(parent.localCompiledBindings.keySet());
        }
        Preprocessor.check(known, bindings);
        Trie<Scope, ScopeLocalData> scopeDataTree = Injector.compileBindingsTrie(parent != null ? parent.scopeCaches.length : 0, scope, bindings, parent != null ? parent.localCompiledBindings : Collections.emptyMap());
        return new Injector(parent, scopeDataTree);
    }

    private static Trie<Scope, ScopeLocalData> compileBindingsTrie(int scope, Scope[] path, Trie<Scope, Map<Key<?>, Binding<?>>> bindings, Map<Key<?>, CompiledBinding<?>> compiledBindingsOfParent) {
        ScopeLocalData scopeLocalData = Injector.compileBindings(scope, path, bindings.get(), compiledBindingsOfParent);
        HashMap children = new HashMap();
        bindings.getChildren().forEach((childScope, trie) -> {
            HashMap compiledBindingsCopy = new HashMap(compiledBindingsOfParent);
            compiledBindingsCopy.putAll(scopeLocalData.compiledBindings);
            children.put(childScope, Injector.compileBindingsTrie(scope + 1, Utils.next(path, childScope), bindings.get((Scope)childScope), compiledBindingsCopy));
        });
        return new Trie<Scope, ScopeLocalData>(scopeLocalData, children);
    }

    private static ScopeLocalData compileBindings(final int scope, Scope[] path, Map<Key<?>, Binding<?>> bindings, Map<Key<?>, CompiledBinding<?>> compiledBindingsOfParent) {
        UnaryOperator<CompiledBinding<?>> postprocessor = bytecodePostprocessorFactory.get();
        boolean threadsafe = path.length == 0 || path[path.length - 1].isThreadsafe();
        HashMap compiledBindings = new HashMap();
        compiledBindings.put(Key.of(Injector.class), (CompiledBinding)postprocessor.apply(scope == 0 ? new CompiledBinding<Object>(){
            volatile Object instance;

            @Override
            @NotNull
            public Object getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                Object instance = this.instance;
                if (instance != null) {
                    return instance;
                }
                this.instance = scopedInstances[scope].get(0);
                return this.instance;
            }
        } : new CompiledBinding<Object>(){

            @Override
            @NotNull
            public Object getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                return scopedInstances[scope].get(0);
            }
        }));
        HashMap slotMapping = new HashMap();
        slotMapping.put(Key.of(Injector.class), 0);
        int[] nextSlot = new int[]{1};
        ArrayList eagerSingletons = new ArrayList();
        for (Map.Entry<Key<?>, Binding<?>> entry : bindings.entrySet()) {
            Key<?> key = entry.getKey();
            Binding<?> binding = entry.getValue();
            CompiledBinding<?> compiledBinding = Injector.compileBinding(postprocessor, scope, path, threadsafe, key, bindings, compiledBindings, compiledBindingsOfParent, slotMapping, nextSlot);
            if (binding.getType() != BindingType.EAGER) continue;
            eagerSingletons.add(compiledBinding);
        }
        bindings.put(Key.of(Injector.class), Binding.to(() -> {
            throw new AssertionError((Object)"Injector constructor must never be called since it's instance is always put in the cache manually");
        }).as(BindingType.EAGER));
        compiledBindingsOfParent.forEach(compiledBindings::putIfAbsent);
        int size = nextSlot[0];
        nextSlot[0] = -1;
        return new ScopeLocalData(path, bindings, compiledBindings, slotMapping, size, eagerSingletons.toArray(new CompiledBinding[0]));
    }

    private static CompiledBinding<?> compileBinding(final UnaryOperator<CompiledBinding<?>> postprocessor, final int scope, final Scope[] path, final boolean threadsafe, Key<?> key, final Map<Key<?>, Binding<?>> bindings, final Map<Key<?>, CompiledBinding<?>> compiledBindings, final Map<Key<?>, CompiledBinding<?>> compiledBindingsOfParent, final Map<Key<?>, Integer> slotMapping, final int[] nextSlot) {
        Key targetKey;
        Integer targetIndex;
        Integer index;
        CompiledBinding<?> already = compiledBindings.get(key);
        if (already != null) {
            return already;
        }
        if (nextSlot[0] == -1) {
            throw new DIException("Failed to locate a binding for " + key.getDisplayString() + " after scope " + Utils.getScopeDisplayString(path) + " was fully compiled");
        }
        Binding<?> binding = bindings.get(key);
        if (binding == null) {
            CompiledBinding<?> compiled = compiledBindingsOfParent.get(key);
            if (compiled == null) {
                throw new AssertionError();
            }
            compiledBindings.put(key, compiled);
            return compiled;
        }
        if (binding instanceof BindingToKey || binding.getType() == BindingType.TRANSIENT) {
            index = null;
        } else {
            int n = nextSlot[0];
            nextSlot[0] = n + 1;
            index = n;
            slotMapping.put(key, index);
        }
        CompiledBinding compiled = (CompiledBinding)postprocessor.apply(binding.compile(new CompiledBindingLocator(){

            @Override
            @NotNull
            public <Q> CompiledBinding<Q> get(Key<Q> key) {
                return Injector.compileBinding(postprocessor, scope, path, threadsafe, key, bindings, compiledBindings, compiledBindingsOfParent, slotMapping, nextSlot);
            }
        }, threadsafe, scope, index));
        if (binding instanceof BindingToKey && (targetIndex = slotMapping.get(targetKey = ((BindingToKey)binding).getKey())) != null) {
            slotMapping.put(key, targetIndex);
        }
        compiledBindings.put(key, compiled);
        return compiled;
    }

    @Override
    @NotNull
    public <T> T getInstance(@NotNull Key<T> key) {
        CompiledBinding<?> binding = this.localCompiledBindings.get(key);
        if (binding == null) {
            throw DIException.cannotConstruct(key, null);
        }
        Object instance = binding.getInstance(this.scopeCaches, -1);
        if (instance == null) {
            throw DIException.cannotConstruct(key, this.scopeDataTree.get().bindings.get(key));
        }
        return (T)instance;
    }

    @Override
    @NotNull
    public <T> T getInstance(@NotNull Class<T> type) {
        return this.getInstance(Key.ofType(type));
    }

    @Override
    @Nullable
    public <T> T getInstanceOrNull(@NotNull Key<T> key) {
        CompiledBinding<?> binding = this.localCompiledBindings.get(key);
        return binding != null ? (T)binding.getInstance(this.scopeCaches, -1) : null;
    }

    @Override
    @Nullable
    public <T> T getInstanceOrNull(@NotNull Class<T> type) {
        return this.getInstanceOrNull(Key.of(type));
    }

    @Override
    public <T> T getInstanceOr(@NotNull Key<T> key, T defaultValue) {
        T instance = this.getInstanceOrNull(key);
        return instance != null ? instance : defaultValue;
    }

    @Override
    public <T> T getInstanceOr(@NotNull Class<T> type, T defaultValue) {
        return this.getInstanceOr(Key.of(type), defaultValue);
    }

    @NotNull
    public <T> InstanceProvider<T> getInstanceProvider(@NotNull Key<T> key) {
        return (InstanceProvider)this.getInstance(Key.ofType(Types.parameterizedType(InstanceProvider.class, (Type[])new Type[]{key.getType()}), key.getQualifier()));
    }

    @NotNull
    public <T> InstanceProvider<T> getInstanceProvider(@NotNull Class<T> type) {
        return this.getInstanceProvider(Key.of(type));
    }

    @NotNull
    public <T> InstanceInjector<T> getInstanceInjector(@NotNull Key<T> key) {
        return (InstanceInjector)this.getInstance(Key.ofType(Types.parameterizedType(InstanceInjector.class, (Type[])new Type[]{key.getType()}), key.getQualifier()));
    }

    @NotNull
    public <T> InstanceInjector<T> getInstanceInjector(@NotNull Class<T> type) {
        return this.getInstanceInjector(Key.of(type));
    }

    @NotNull
    public <T> OptionalDependency<T> getOptionalDependency(@NotNull Key<T> key) {
        return (OptionalDependency)this.getInstance(Key.ofType(Types.parameterizedType(OptionalDependency.class, (Type[])new Type[]{key.getType()}), key.getQualifier()));
    }

    @NotNull
    public <T> OptionalDependency<T> getOptionalDependency(@NotNull Class<T> type) {
        return this.getOptionalDependency(Key.of(type));
    }

    public void createEagerInstances() {
        for (CompiledBinding<?> compiledBinding : this.scopeDataTree.get().eagerSingletons) {
            compiledBinding.getInstance(this.scopeCaches, -1);
        }
    }

    @Nullable
    public <T> T peekInstance(@NotNull Key<T> key) {
        Integer index = this.localSlotMapping.get(key);
        return index != null ? (T)this.scopeCaches[this.scopeCaches.length - 1].get(index) : null;
    }

    @Nullable
    public <T> T peekInstance(@NotNull Class<T> type) {
        return this.peekInstance(Key.of(type));
    }

    public boolean hasInstance(@NotNull Key<?> key) {
        return this.peekInstance(key) != null;
    }

    public boolean hasInstance(@NotNull Class<?> type) {
        return this.peekInstance(type) != null;
    }

    public Map<Key<?>, Object> peekInstances() {
        HashMap result = new HashMap();
        AtomicReferenceArray scopeCache = this.scopeCaches[this.scopeCaches.length - 1];
        for (Map.Entry<Key<?>, Integer> entry : this.localSlotMapping.entrySet()) {
            Object value = scopeCache.get(entry.getValue());
            if (value == null) continue;
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public <T> void putInstance(Key<T> key, T instance) {
        Integer index = this.localSlotMapping.get(key);
        if (index == null) {
            throw DIException.noCachedBinding(key, this.getScope());
        }
        this.scopeCaches[this.scopeCaches.length - 1].lazySet(index, instance);
    }

    public <T> void putInstance(Class<T> key, T instance) {
        this.putInstance(Key.of(key), instance);
    }

    @Nullable
    public Binding<?> getBinding(Class<?> type) {
        return this.getBinding(Key.of(type));
    }

    @Nullable
    public Binding<?> getBinding(Key<?> key) {
        return this.scopeDataTree.get().bindings.get(key);
    }

    public boolean hasBinding(Key<?> key) {
        return this.scopeDataTree.get().bindings.containsKey(key);
    }

    public boolean hasBinding(Class<?> type) {
        return this.hasBinding(Key.of(type));
    }

    public Injector enterScope(@NotNull Scope scope) {
        return new Injector(this, this.scopeDataTree.get(scope));
    }

    @Nullable
    public Injector getParent() {
        return this.parent;
    }

    public Scope[] getScope() {
        return this.scopeDataTree.get().scope;
    }

    public Map<Key<?>, Binding<?>> getBindings() {
        return this.scopeDataTree.get().bindings;
    }

    public Trie<Scope, Map<Key<?>, Binding<?>>> getBindingsTrie() {
        return this.scopeDataTree.map(graph -> graph.bindings);
    }

    public String toString() {
        return "Injector{scope=" + Utils.getScopeDisplayString(this.scopeDataTree.get().scope) + '}';
    }

    private static final class ScopeLocalData {
        final Scope[] scope;
        final Map<Key<?>, Binding<?>> bindings;
        final Map<Key<?>, CompiledBinding<?>> compiledBindings;
        final Map<Key<?>, Integer> slotMapping;
        final int slots;
        final CompiledBinding<?>[] eagerSingletons;

        private ScopeLocalData(Scope[] scope, Map<Key<?>, Binding<?>> bindings, Map<Key<?>, CompiledBinding<?>> compiledBindings, Map<Key<?>, Integer> slotMapping, int slots, CompiledBinding<?>[] eagerSingletons) {
            this.scope = scope;
            this.bindings = bindings;
            this.compiledBindings = compiledBindings;
            this.slotMapping = slotMapping;
            this.slots = slots;
            this.eagerSingletons = eagerSingletons;
        }
    }
}

