/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject;

import io.activej.inject.util.ReflectionUtils;
import io.activej.inject.util.TypeUtils;
import io.activej.inject.util.Utils;
import io.activej.types.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Key<T> {
    @NotNull
    private final Type type;
    @Nullable
    private final Object qualifier;
    private int hash;

    protected Key() {
        this.type = TypeUtils.simplifyType(this.getTypeParameter());
        this.qualifier = null;
    }

    protected Key(@Nullable Object qualifier) {
        this.type = TypeUtils.simplifyType(this.getTypeParameter());
        this.qualifier = qualifier;
    }

    Key(@NotNull Type type, @Nullable Object qualifier) {
        this.type = TypeUtils.simplifyType(type);
        this.qualifier = qualifier;
    }

    @NotNull
    public static <T> Key<T> of(@NotNull Class<T> type) {
        return new KeyImpl(type, null);
    }

    @NotNull
    public static <T> Key<T> of(@NotNull Class<T> type, @Nullable Object qualifier) {
        return new KeyImpl(type, qualifier);
    }

    @NotNull
    public static <T> Key<T> ofType(@NotNull Type type) {
        return new KeyImpl(type, null);
    }

    @NotNull
    public static <T> Key<T> ofType(@NotNull Type type, @Nullable Object qualifier) {
        return new KeyImpl(type, qualifier);
    }

    public Key<T> qualified(Object qualifier) {
        return new KeyImpl(this.type, qualifier);
    }

    @NotNull
    private Type getTypeParameter() {
        Type typeArgument = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Object outerInstance = ReflectionUtils.getOuterClassInstance(this);
        return outerInstance != null ? Types.bind((Type)typeArgument, (Map)Types.getAllTypeBindings(outerInstance.getClass())) : typeArgument;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @NotNull
    public Class<T> getRawType() {
        return Types.getRawType((Type)this.type);
    }

    public <U> Key<U> getTypeParameter(int index) {
        if (this.type instanceof ParameterizedType) {
            return new KeyImpl(((ParameterizedType)this.type).getActualTypeArguments()[index], null);
        }
        throw new IllegalStateException("Expected type from key " + this.getDisplayString() + " to be parameterized");
    }

    @Nullable
    public Object getQualifier() {
        return this.qualifier;
    }

    public String getDisplayString() {
        return (this.qualifier != null ? Utils.getDisplayString(this.qualifier) + " " : "") + ReflectionUtils.getDisplayName(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key that = (Key)o;
        return this.type.equals(that.type) && Objects.equals(this.qualifier, that.qualifier);
    }

    public int hashCode() {
        int hashCode = this.hash;
        if (hashCode == 0) {
            this.hash = 31 * this.type.hashCode() + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        }
        return this.hash;
    }

    public String toString() {
        return (this.qualifier != null ? this.qualifier + " " : "") + this.type.getTypeName();
    }

    private static final class KeyImpl<T>
    extends Key<T> {
        private KeyImpl(Type type, Object qualifier) {
            super(type, qualifier);
        }
    }
}

