/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject;

import io.activej.inject.Key;
import io.activej.inject.util.ReflectionUtils;
import io.activej.types.IsAssignableUtils;
import io.activej.types.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public abstract class KeyPattern<T> {
    @NotNull
    private final Type type;
    private final Predicate<?> qualifier;

    protected KeyPattern() {
        this.type = this.getTypeParameter();
        this.qualifier = null;
    }

    protected KeyPattern(Object qualifier) {
        this.type = this.getTypeParameter();
        this.qualifier = KeyPattern.predicateOf(qualifier);
    }

    protected KeyPattern(Predicate<?> qualifier) {
        this.type = this.getTypeParameter();
        this.qualifier = qualifier;
    }

    KeyPattern(@NotNull Type type, Predicate<?> qualifier) {
        this.type = type;
        this.qualifier = qualifier;
    }

    @NotNull
    public static <T> KeyPattern<T> create(@NotNull Type type, Predicate<?> qualifier) {
        return new KeyImpl(type, qualifier);
    }

    @NotNull
    public static <T> KeyPattern<T> of(@NotNull Class<T> type) {
        return new KeyImpl(type, null);
    }

    @NotNull
    public static <T> KeyPattern<T> of(@NotNull Class<T> type, Object qualifier) {
        return new KeyImpl(type, KeyPattern.predicateOf(qualifier));
    }

    @NotNull
    public static <T> KeyPattern<T> ofType(@NotNull Type type) {
        return new KeyImpl(type, null);
    }

    @NotNull
    public static <T> KeyPattern<T> ofType(@NotNull Type type, Object qualifier) {
        return new KeyImpl(type, KeyPattern.predicateOf(qualifier));
    }

    @NotNull
    private static Predicate<Object> predicateOf(Object qualifier) {
        return q -> Objects.equals(q, qualifier);
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public boolean match(Key<?> key) {
        return IsAssignableUtils.isAssignable((Type)this.type, (Type)key.getType()) && (this.qualifier == null || this.qualifier.test(key.getQualifier()));
    }

    @NotNull
    private Type getTypeParameter() {
        Type typeArgument = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Object outerInstance = ReflectionUtils.getOuterClassInstance(this);
        return outerInstance != null ? Types.bind((Type)typeArgument, (Map)Types.getAllTypeBindings(outerInstance.getClass())) : typeArgument;
    }

    public String toString() {
        return (this.qualifier != null ? this.qualifier + " " : "") + this.type.getTypeName();
    }

    private static final class KeyImpl<T>
    extends KeyPattern<T> {
        private KeyImpl(Type type, Predicate<?> qualifierPredicate) {
            super(type, qualifierPredicate);
        }
    }
}

