/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject;

import io.activej.inject.annotation.ScopeAnnotation;
import io.activej.inject.util.Utils;
import java.lang.annotation.Annotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scope {
    public static final Scope[] UNSCOPED = new Scope[0];
    @NotNull
    private final Class<? extends Annotation> annotationType;
    private final boolean threadsafe;

    private Scope(@NotNull Class<? extends Annotation> annotationType, boolean threadsafe) {
        this.annotationType = annotationType;
        this.threadsafe = threadsafe;
    }

    public static Scope of(Class<? extends Annotation> annotationType) {
        Utils.checkArgument(Utils.isMarker(annotationType), "Scope by annotation type only accepts marker annotations with no arguments");
        ScopeAnnotation scopeAnnotation = annotationType.getAnnotation(ScopeAnnotation.class);
        Utils.checkArgument(scopeAnnotation != null, "Only annotations annotated with @ScopeAnnotation meta-annotation are allowed");
        return new Scope(annotationType, scopeAnnotation.threadsafe());
    }

    public static Scope of(Annotation annotation) {
        return Scope.of(annotation.annotationType());
    }

    @NotNull
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public boolean isThreadsafe() {
        return this.threadsafe;
    }

    public String getDisplayString() {
        return this.annotationType.getSimpleName();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope other = (Scope)o;
        return this.annotationType == other.annotationType;
    }

    public int hashCode() {
        return 31 * this.annotationType.hashCode();
    }

    public String toString() {
        return "@" + this.annotationType.getName() + "()";
    }
}

