/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.binding;

import io.activej.inject.Key;
import io.activej.inject.binding.BindingToKey;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.Bindings;
import io.activej.inject.binding.DIException;
import io.activej.inject.impl.AbstractCompiledBinding;
import io.activej.inject.impl.BindingInitializer;
import io.activej.inject.impl.CompiledBinding;
import io.activej.inject.impl.CompiledBindingInitializer;
import io.activej.inject.impl.CompiledBindingLocator;
import io.activej.inject.util.Constructors;
import io.activej.inject.util.LocationInfo;
import io.activej.inject.util.Utils;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Binding<T> {
    private final Set<Key<?>> dependencies;
    private BindingType type;
    @Nullable
    private LocationInfo location;

    protected Binding(@NotNull Set<Key<?>> dependencies) {
        this(dependencies, BindingType.REGULAR, null);
    }

    protected Binding(@NotNull Set<Key<?>> dependencies, BindingType type, @Nullable LocationInfo location) {
        this.dependencies = dependencies;
        this.type = type;
        this.location = location;
    }

    public static <T> Binding<T> toInstance(@NotNull T instance) {
        return new Bindings.BindingToInstance<T>(instance);
    }

    public static <T> Binding<T> to(Class<? extends T> key) {
        return Binding.to(Key.of(key));
    }

    public static <T> Binding<T> to(Key<? extends T> key) {
        return new BindingToKey<T>(key);
    }

    public static <R> Binding<R> to(@NotNull Constructors.ConstructorN<R> constructor, Class<?>[] types) {
        return Binding.to(constructor, (Key[])Stream.of(types).map(Key::of).toArray(Key[]::new));
    }

    public static <R> Binding<R> to(@NotNull Constructors.ConstructorN<R> constructor, Key<?>[] dependencies) {
        if (dependencies.length == 0) {
            return Binding.to(() -> constructor.create(new Object[0]));
        }
        return new Bindings.BindingToConstructorN<R>(constructor, dependencies);
    }

    public static <T1, R> Binding<R> to(@NotNull Constructors.Constructor1<T1, R> constructor, @NotNull Class<T1> dependency1) {
        return Binding.to(constructor, Key.of(dependency1));
    }

    public static <T1, T2, R> Binding<R> to(@NotNull Constructors.Constructor2<T1, T2, R> constructor, @NotNull Class<T1> dependency1, @NotNull Class<T2> dependency2) {
        return Binding.to(constructor, Key.of(dependency1), Key.of(dependency2));
    }

    public static <T1, T2, T3, R> Binding<R> to(@NotNull Constructors.Constructor3<T1, T2, T3, R> constructor, @NotNull Class<T1> dependency1, @NotNull Class<T2> dependency2, @NotNull Class<T3> dependency3) {
        return Binding.to(constructor, Key.of(dependency1), Key.of(dependency2), Key.of(dependency3));
    }

    public static <T1, T2, T3, T4, R> Binding<R> to(@NotNull Constructors.Constructor4<T1, T2, T3, T4, R> constructor, @NotNull Class<T1> dependency1, @NotNull Class<T2> dependency2, @NotNull Class<T3> dependency3, @NotNull Class<T4> dependency4) {
        return Binding.to(constructor, Key.of(dependency1), Key.of(dependency2), Key.of(dependency3), Key.of(dependency4));
    }

    public static <T1, T2, T3, T4, T5, R> Binding<R> to(@NotNull Constructors.Constructor5<T1, T2, T3, T4, T5, R> constructor, @NotNull Class<T1> dependency1, @NotNull Class<T2> dependency2, @NotNull Class<T3> dependency3, @NotNull Class<T4> dependency4, @NotNull Class<T5> dependency5) {
        return Binding.to(constructor, Key.of(dependency1), Key.of(dependency2), Key.of(dependency3), Key.of(dependency4), Key.of(dependency5));
    }

    public static <T1, T2, T3, T4, T5, T6, R> Binding<R> to(@NotNull Constructors.Constructor6<T1, T2, T3, T4, T5, T6, R> constructor, @NotNull Class<T1> dependency1, @NotNull Class<T2> dependency2, @NotNull Class<T3> dependency3, @NotNull Class<T4> dependency4, @NotNull Class<T5> dependency5, @NotNull Class<T6> dependency6) {
        return Binding.to(constructor, Key.of(dependency1), Key.of(dependency2), Key.of(dependency3), Key.of(dependency4), Key.of(dependency5), Key.of(dependency6));
    }

    public static <R> Binding<R> to(@NotNull Constructors.Constructor0<R> constructor) {
        return new Bindings.BindingToConstructor0<R>(constructor);
    }

    public static <T1, R> Binding<R> to(@NotNull Constructors.Constructor1<T1, R> constructor, @NotNull Key<T1> dependency1) {
        return new Bindings.BindingToConstructor1<R, T1>(constructor, dependency1);
    }

    public static <T1, T2, R> Binding<R> to(@NotNull Constructors.Constructor2<T1, T2, R> constructor, @NotNull Key<T1> dependency1, @NotNull Key<T2> dependency2) {
        return new Bindings.BindingToConstructor2<R, T1, T2>(dependency1, dependency2, constructor);
    }

    public static <T1, T2, T3, R> Binding<R> to(@NotNull Constructors.Constructor3<T1, T2, T3, R> constructor, @NotNull Key<T1> dependency1, @NotNull Key<T2> dependency2, @NotNull Key<T3> dependency3) {
        return new Bindings.BindingToConstructor3<R, T1, T2, T3>(constructor, dependency1, dependency2, dependency3);
    }

    public static <T1, T2, T3, T4, R> Binding<R> to(@NotNull Constructors.Constructor4<T1, T2, T3, T4, R> constructor, @NotNull Key<T1> dependency1, @NotNull Key<T2> dependency2, @NotNull Key<T3> dependency3, @NotNull Key<T4> dependency4) {
        return new Bindings.BindingToConstructor4<R, T1, T2, T3, T4>(constructor, dependency1, dependency2, dependency3, dependency4);
    }

    public static <T1, T2, T3, T4, T5, R> Binding<R> to(@NotNull Constructors.Constructor5<T1, T2, T3, T4, T5, R> constructor, @NotNull Key<T1> dependency1, @NotNull Key<T2> dependency2, @NotNull Key<T3> dependency3, @NotNull Key<T4> dependency4, @NotNull Key<T5> dependency5) {
        return new Bindings.BindingToConstructor5<R, T1, T2, T3, T4, T5>(constructor, dependency1, dependency2, dependency3, dependency4, dependency5);
    }

    public static <T1, T2, T3, T4, T5, T6, R> Binding<R> to(@NotNull Constructors.Constructor6<T1, T2, T3, T4, T5, T6, R> constructor, @NotNull Key<T1> dependency1, @NotNull Key<T2> dependency2, @NotNull Key<T3> dependency3, @NotNull Key<T4> dependency4, @NotNull Key<T5> dependency5, @NotNull Key<T6> dependency6) {
        return new Bindings.BindingToConstructor6<R, T1, T2, T3, T4, T5, T6>(constructor, dependency1, dependency2, dependency3, dependency4, dependency5, dependency6);
    }

    public Binding<T> at(@Nullable LocationInfo location) {
        this.location = location;
        return this;
    }

    public Binding<T> as(BindingType type) {
        this.type = type;
        return this;
    }

    public Binding<T> onInstance(@NotNull @NotNull Consumer<? super @NotNull T> consumer) {
        return this.mapInstance(instance -> {
            consumer.accept(instance);
            return instance;
        });
    }

    public <R> Binding<R> mapInstance(final @NotNull @NotNull Function<? super @NotNull T, ? extends @NotNull R> fn) {
        return new Binding<R>(this.dependencies, this.type, this.location){

            @Override
            public CompiledBinding<R> compile(CompiledBindingLocator compiledBindings, boolean threadsafe, int scope, @Nullable Integer slot) {
                final CompiledBinding originalBinding = Binding.this.compile(compiledBindings, threadsafe, scope, null);
                return slot != null ? new AbstractCompiledBinding<R>(scope, slot){

                    @Override
                    @NotNull
                    protected R doCreateInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        Object instance = originalBinding.getInstance(scopedInstances, synchronizedScope);
                        return fn.apply(instance);
                    }
                } : new CompiledBinding<R>(){

                    @Override
                    @NotNull
                    public R getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        Object instance = originalBinding.getInstance(scopedInstances, synchronizedScope);
                        return fn.apply(instance);
                    }
                };
            }
        };
    }

    public <R> Binding<R> mapInstance(final @NotNull List<Key<?>> dependencies, final @NotNull @NotNull BiFunction<Object[], ? super @NotNull T, ? extends @NotNull R> fn) {
        Set missing = dependencies.stream().filter(required -> !this.dependencies.contains(required)).collect(Collectors.toSet());
        if (!missing.isEmpty()) {
            throw new DIException(missing.stream().map(Key::getDisplayString).collect(Collectors.joining(", ", "Binding has no dependencies ", " required by mapInstance call")));
        }
        return new Binding<R>(this.dependencies, this.type, this.location){

            @Override
            public CompiledBinding<R> compile(CompiledBindingLocator compiledBindings, boolean threadsafe, int scope, @Nullable Integer slot) {
                final CompiledBinding originalBinding = Binding.this.compile(compiledBindings, threadsafe, scope, null);
                final CompiledBinding[] bindings = (CompiledBinding[])dependencies.stream().map(compiledBindings::get).toArray(CompiledBinding[]::new);
                return slot != null ? new AbstractCompiledBinding<R>(scope, slot){

                    @Override
                    @NotNull
                    protected R doCreateInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        Object[] args = new Object[bindings.length];
                        for (int i = 0; i < bindings.length; ++i) {
                            args[i] = bindings[i].getInstance(scopedInstances, synchronizedScope);
                        }
                        Object instance = originalBinding.getInstance(scopedInstances, synchronizedScope);
                        return fn.apply(args, instance);
                    }
                } : new CompiledBinding<R>(){

                    @Override
                    @NotNull
                    public R getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        Object[] args = new Object[bindings.length];
                        for (int i = 0; i < bindings.length; ++i) {
                            args[i] = bindings[i].getInstance(scopedInstances, synchronizedScope);
                        }
                        Object instance = originalBinding.getInstance(scopedInstances, synchronizedScope);
                        return fn.apply(args, instance);
                    }
                };
            }
        };
    }

    public <K> Binding<T> onDependency(@NotNull Class<K> dependency, @NotNull Consumer<? super K> consumer) {
        return this.onDependency(Key.of(dependency), consumer);
    }

    public <K> Binding<T> onDependency(@NotNull Key<K> dependency, @NotNull Consumer<? super K> consumer) {
        return this.mapDependency(dependency, (? super K v) -> {
            consumer.accept((Object)v);
            return v;
        });
    }

    public <K> Binding<T> mapDependency(@NotNull Class<K> dependency, @NotNull Function<? super K, ? extends K> fn) {
        return this.mapDependency(Key.of(dependency), fn);
    }

    public <K> Binding<T> mapDependency(final @NotNull Key<K> dependency, final @NotNull Function<? super K, ? extends K> fn) {
        return new Binding<T>(this.dependencies, this.type, this.location){

            @Override
            public CompiledBinding<T> compile(final CompiledBindingLocator compiledBindings, boolean threadsafe, int scope, @Nullable Integer slot) {
                return Binding.this.compile(new CompiledBindingLocator(){

                    @Override
                    @NotNull
                    public <Q> CompiledBinding<Q> get(Key<Q> key) {
                        final CompiledBinding<Q> originalBinding = compiledBindings.get(key);
                        if (!key.equals(dependency)) {
                            return originalBinding;
                        }
                        return new CompiledBinding<Q>(){

                            @Override
                            @NotNull
                            public Q getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                                Object instance = originalBinding.getInstance(scopedInstances, synchronizedScope);
                                return fn.apply(instance);
                            }
                        };
                    }
                }, threadsafe, scope, slot);
            }
        };
    }

    public Binding<T> addDependencies(Class<?> ... extraDependencies) {
        return this.addDependencies((Key[])Stream.of(extraDependencies).map(Key::of).toArray(Key[]::new));
    }

    public Binding<T> addDependencies(Key<?> ... extraDependencies) {
        return this.addDependencies(Stream.of(extraDependencies).collect(Collectors.toSet()));
    }

    public Binding<T> addDependencies(final @NotNull Set<Key<?>> extraDependencies) {
        return extraDependencies.isEmpty() ? this : new Binding<T>(Utils.union(this.dependencies, extraDependencies), this.type, this.location){

            @Override
            public CompiledBinding<T> compile(CompiledBindingLocator compiledBindings, boolean threadsafe, int scope, @Nullable Integer slot) {
                final CompiledBinding compiledBinding = Binding.this.compile(compiledBindings, threadsafe, scope, slot);
                final CompiledBinding[] compiledExtraBindings = (CompiledBinding[])extraDependencies.stream().map(compiledBindings::get).toArray(CompiledBinding[]::new);
                return new CompiledBinding<T>(){

                    @Override
                    @NotNull
                    public T getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        for (int i = 0; i < compiledExtraBindings.length; ++i) {
                            compiledExtraBindings[i].getInstance(scopedInstances, synchronizedScope);
                        }
                        return compiledBinding.getInstance(scopedInstances, synchronizedScope);
                    }
                };
            }
        };
    }

    public Binding<T> initializeWith(final BindingInitializer<T> bindingInitializer) {
        return bindingInitializer == BindingInitializer.noop() ? this : new Binding<T>(Utils.union(this.dependencies, bindingInitializer.getDependencies()), this.type, this.location){

            @Override
            public CompiledBinding<T> compile(CompiledBindingLocator compiledBindings, boolean threadsafe, int scope, @Nullable Integer slot) {
                final CompiledBinding compiledBinding = Binding.this.compile(compiledBindings, threadsafe, scope, null);
                final CompiledBindingInitializer consumer = bindingInitializer.compile(compiledBindings);
                return slot != null ? new AbstractCompiledBinding<T>(scope, slot){

                    @Override
                    @NotNull
                    protected T doCreateInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        Object instance = compiledBinding.getInstance(scopedInstances, synchronizedScope);
                        consumer.initInstance(instance, scopedInstances, synchronizedScope);
                        return instance;
                    }
                } : new CompiledBinding<T>(){

                    @Override
                    @NotNull
                    public T getInstance(AtomicReferenceArray[] scopedInstances, int synchronizedScope) {
                        Object instance = compiledBinding.getInstance(scopedInstances, synchronizedScope);
                        consumer.initInstance(instance, scopedInstances, synchronizedScope);
                        return instance;
                    }
                };
            }
        };
    }

    public abstract CompiledBinding<T> compile(CompiledBindingLocator var1, boolean var2, int var3, @Nullable Integer var4);

    @NotNull
    public Set<Key<?>> getDependencies() {
        return this.dependencies;
    }

    public boolean hasDependency(Key<?> dependency) {
        return this.dependencies.stream().anyMatch(Predicate.isEqual(dependency));
    }

    public BindingType getType() {
        return this.type;
    }

    @Nullable
    public LocationInfo getLocation() {
        return this.location;
    }

    public String getDisplayString() {
        return this.dependencies.stream().map(Key::getDisplayString).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return "Binding" + this.dependencies.toString();
    }
}

