/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.binding;

import io.activej.inject.KeyPattern;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.util.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class BindingGenerators {
    private static final BindingGenerator<Object> REFUSING = (bindings, scope, key) -> null;

    public static <T> BindingGenerator<T> refusing() {
        return REFUSING;
    }

    public static BindingGenerator<?> combinedGenerator(Map<KeyPattern<?>, Set<BindingGenerator<?>>> generators) {
        LinkedHashMap sorted = Utils.sortPatternsMap(generators);
        return (bindings, scope, key) -> {
            for (Map.Entry entry : sorted.entrySet()) {
                if (!((KeyPattern)entry.getKey()).match(key)) continue;
                for (BindingGenerator generator : (Set)entry.getValue()) {
                    @Nullable Binding<T> generated = generator.generate(bindings, scope, key);
                    if (generated == null) continue;
                    return generated;
                }
            }
            return null;
        };
    }
}

