/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.binding;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalDependency<T> {
    private static final OptionalDependency<?> EMPTY = new OptionalDependency<Object>(null);
    @Nullable
    private final T value;

    private OptionalDependency(@Nullable T value) {
        this.value = value;
    }

    public static <T> OptionalDependency<T> of(@NotNull T value) {
        if (value instanceof OptionalDependency) {
            throw new IllegalArgumentException("Nested optional dependencies are not allowed");
        }
        return new OptionalDependency<T>(value);
    }

    public static <T> OptionalDependency<T> empty() {
        return EMPTY;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalDependency that = (OptionalDependency)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "OptionalDependency{" + (this.value == null ? "empty" : "value=" + this.value) + '}';
    }
}

