/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.module;

import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.binding.BindingTransformer;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.module.Module;
import io.activej.inject.module.ModuleBuilder;
import io.activej.inject.module.ModuleBuilder0;
import io.activej.inject.module.ModuleBuilderImpl;
import io.activej.inject.util.ReflectionUtils;
import io.activej.inject.util.Trie;
import io.activej.inject.util.Utils;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModule
implements Module {
    private Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings;
    private Map<KeyPattern<?>, Set<BindingGenerator<?>>> bindingGenerators;
    private Map<KeyPattern<?>, Set<BindingTransformer<?>>> bindingTransformers;
    private Map<Key<?>, Multibinder<?>> multibinders;
    @Nullable
    private ModuleBuilder builder;
    @Nullable
    private final StackTraceElement location;

    protected AbstractModule() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        StackTraceElement found = null;
        Class<?> cls = this.getClass();
        for (int i = 2; i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            try {
                String className = element.getClassName();
                Class<?> traceCls = Class.forName(className);
                if (traceCls.isAssignableFrom(cls) || className.startsWith("sun.reflect") || className.startsWith("java.lang")) continue;
                found = element;
            }
            catch (ClassNotFoundException ignored) {}
            break;
        }
        this.location = found;
        this.builder = new ModuleBuilderImpl(this.getName(), this.location);
    }

    protected void configure() {
    }

    protected final <T> ModuleBuilder0<T> bind(@NotNull Key<T> key) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        return this.builder.bind(key);
    }

    protected final <T> ModuleBuilder0<T> bind(Class<T> type) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        return this.builder.bind(type);
    }

    protected final <T> ModuleBuilder0<T> bind(Class<T> type, Object qualifier) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        return this.builder.bind(type, qualifier);
    }

    protected final <T> void bindInstanceProvider(@NotNull Class<T> key) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.bindInstanceProvider(key);
    }

    protected final <T> void bindInstanceProvider(@NotNull Key<T> key) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.bindInstanceProvider(key);
    }

    protected final <T> void bindInstanceInjector(@NotNull Class<T> key) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.bindInstanceInjector(key);
    }

    protected final <T> void bindInstanceInjector(@NotNull Key<T> key) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.bindInstanceInjector(key);
    }

    protected final <T> void bindOptionalDependency(@NotNull Class<T> key) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.bindOptionalDependency(key);
    }

    protected final <T> void bindOptionalDependency(@NotNull Key<T> key) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.bindOptionalDependency(key);
    }

    protected final void install(Module module) {
        Utils.checkState(this.builder != null, "Cannot install modules before or after configure() call");
        this.builder.install(module);
    }

    protected final <T> void generate(KeyPattern<T> pattern, BindingGenerator<T> bindingGenerator) {
        Utils.checkState(this.builder != null, "Cannot add generators before or after configure() call");
        this.builder.generate(pattern, bindingGenerator);
    }

    protected final <T> void generate(Class<T> pattern, BindingGenerator<T> bindingGenerator) {
        this.generate(KeyPattern.of(pattern), bindingGenerator);
    }

    protected final <T> void transform(KeyPattern<T> pattern, BindingTransformer<T> bindingTransformer) {
        Utils.checkState(this.builder != null, "Cannot add transformers before or after configure() call");
        this.builder.transform(pattern, bindingTransformer);
    }

    protected final <T> void transform(Class<T> pattern, BindingTransformer<T> bindingTransformer) {
        this.transform(KeyPattern.of(pattern), bindingTransformer);
    }

    protected final <T> void multibind(Key<T> key, Multibinder<T> multibinder) {
        Utils.checkState(this.builder != null, "Cannot add multibinders before or after configure() call");
        this.builder.multibind(key, multibinder);
    }

    protected final <V> void multibindToSet(Class<V> type) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.multibindToSet(type);
    }

    protected final <V> void multibindToSet(Class<V> type, Object qualifier) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.multibindToSet(type, qualifier);
    }

    protected final <V> void multibindToSet(Key<V> key) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.multibindToSet(key);
    }

    protected final <K, V> void multibindToMap(Class<K> keyType, Class<V> valueType) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.multibindToMap(keyType, valueType);
    }

    protected final <K, V> void multibindToMap(Class<K> keyType, Class<V> valueType, Object qualifier) {
        Utils.checkState(this.builder != null, "Cannot add bindings before or after configure() call");
        this.builder.multibindToMap(keyType, valueType, qualifier);
    }

    protected final <S, T extends S> void bindIntoSet(Key<S> setOf, Binding<T> binding) {
        Utils.checkState(this.builder != null, "Cannot bind into set before or after configure() call");
        this.builder.bindIntoSet(setOf, binding);
    }

    protected final <S, T extends S> void bindIntoSet(Key<S> setOf, Key<T> item) {
        this.bindIntoSet(setOf, (T)Binding.to(item));
    }

    protected final <S, T extends S> void bindIntoSet(@NotNull Key<S> setOf, @NotNull T element) {
        this.bindIntoSet(setOf, (T)Binding.toInstance(element));
    }

    protected final void scan(Object object) {
        Utils.checkState(this.builder != null, "Cannot add declarative bindings before or after configure() call");
        this.builder.scan(object);
    }

    protected final void scan(Class<?> cls) {
        Utils.checkState(this.builder != null, "Cannot add declarative bindings before or after configure() call");
        this.builder.scan(cls);
    }

    private void finish() {
        if (this.builder == null) {
            return;
        }
        this.builder.scan(this.getClass().getSuperclass(), this);
        ReflectionUtils.scanClassInto(this.getClass(), this, this.builder);
        this.configure();
        Module module = this.builder.build();
        this.builder = null;
        this.bindings = module.getBindings();
        this.bindingTransformers = module.getBindingTransformers();
        this.bindingGenerators = module.getBindingGenerators();
        this.multibinders = module.getMultibinders();
    }

    @Override
    public final Trie<Scope, Map<Key<?>, Set<Binding<?>>>> getBindings() {
        this.finish();
        return this.bindings;
    }

    @Override
    public final Map<KeyPattern<?>, Set<BindingTransformer<?>>> getBindingTransformers() {
        this.finish();
        return this.bindingTransformers;
    }

    @Override
    public final Map<KeyPattern<?>, Set<BindingGenerator<?>>> getBindingGenerators() {
        this.finish();
        return this.bindingGenerators;
    }

    @Override
    public final Map<Key<?>, Multibinder<?>> getMultibinders() {
        this.finish();
        return this.multibinders;
    }

    @Override
    public Module combineWith(Module another) {
        return Module.super.combineWith(another);
    }

    @Override
    public Module overrideWith(Module another) {
        return Module.super.overrideWith(another);
    }

    @Override
    public Module transformWith(UnaryOperator<Module> fn) {
        return Module.super.transformWith(fn);
    }

    private String getName() {
        Class<?> cls = this.getClass();
        return ReflectionUtils.getDisplayName(cls.isAnonymousClass() ? cls.getGenericSuperclass() : cls);
    }

    public String toString() {
        return this.getName() + "(at " + (this.location != null ? this.location : "<unknown module location>") + ')';
    }
}

